/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control.element;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.element.ControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.options.control.element.SodiumControlElement;
import me.jellysquid.mods.sodium.client.gui.utils.Rect2i;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.util.MathHelper;

public class SodiumControlElementFactory
implements ControlElementFactory {
    @Override
    public <T extends Enum<T>> ControlElement<T> cyclingControlElement(Option<T> option, Dim2i dim, T[] allowedValues, String[] names) {
        return new CyclingControlElement(option, dim, allowedValues, names);
    }

    @Override
    public ControlElement<Integer> sliderControlElement(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
        return new SliderControlElement(option, dim, min, max, interval, formatter);
    }

    @Override
    public ControlElement<Boolean> tickBoxElement(Option<Boolean> option, Dim2i dim) {
        return new TickBoxControlElement(option, dim);
    }

    private static class CyclingControlElement<T extends Enum<T>>
    extends SodiumControlElement<T> {
        private final T[] allowedValues;
        private final String[] names;
        private int currentIndex;

        public CyclingControlElement(Option<T> option, Dim2i dim, T[] allowedValues, String[] names) {
            super(option, dim);
            this.allowedValues = allowedValues;
            this.names = names;
            this.currentIndex = 0;
            for (int i = 0; i < allowedValues.length; ++i) {
                if (allowedValues[i] != option.getValue()) continue;
                this.currentIndex = i;
                break;
            }
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            Enum value = (Enum)this.option.getValue();
            String name = this.names[value.ordinal()];
            int strWidth = this.getTextWidth(name);
            this.drawString(name, this.dim.getLimitX() - strWidth - 6, this.dim.getCenterY() - 4, -1);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (AngelicaConfig.enableReesesSodiumOptions) {
                if (this.option.isAvailable() && this.dim.containsCursor(mouseX, mouseY) && (button == 0 || button == 1)) {
                    this.currentIndex = Math.floorMod(((Enum)this.option.getValue()).ordinal() + (button == 0 ? 1 : -1), this.allowedValues.length);
                    this.option.setValue(this.allowedValues[this.currentIndex]);
                    this.playClickSound();
                    return true;
                }
            } else if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.currentIndex = (((Enum)this.option.getValue()).ordinal() + 1) % this.allowedValues.length;
                this.option.setValue(this.allowedValues[this.currentIndex]);
                this.playClickSound();
                return true;
            }
            return false;
        }
    }

    private static class SliderControlElement
    extends SodiumControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Rect2i sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public SliderControlElement(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new Rect2i(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider();
            } else {
                this.renderStandaloneValue();
            }
        }

        private void renderStandaloneValue() {
            int sliderX = this.sliderBounds.getX();
            int sliderY = this.sliderBounds.getY();
            int sliderWidth = this.sliderBounds.getWidth();
            int sliderHeight = this.sliderBounds.getHeight();
            String label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.func_78256_a(label);
            this.drawString(label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider() {
            int sliderX = this.sliderBounds.getX();
            int sliderY = this.sliderBounds.getY();
            int sliderWidth = this.sliderBounds.getWidth();
            int sliderHeight = this.sliderBounds.getHeight();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = MathHelper.func_151237_a((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            double thumbX = (double)sliderX + thumbOffset - 2.0;
            double trackY = (double)(sliderY + sliderHeight / 2) - 0.5;
            this.drawRect(thumbX, sliderY, thumbX + 4.0, sliderY + sliderHeight, -1);
            this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1.0, -1);
            String label = String.valueOf(this.getIntValue());
            int labelWidth = this.font.func_78256_a(label);
            this.drawString(label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.contains((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.getX()) / (double)this.sliderBounds.getWidth());
        }

        private void setValue(double d) {
            this.thumbPosition = MathHelper.func_151237_a((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && this.sliderBounds.contains((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }

    private static class TickBoxControlElement
    extends SodiumControlElement<Boolean> {
        private final Rect2i button;

        public TickBoxControlElement(Option<Boolean> option, Dim2i dim) {
            super(option, dim);
            this.button = new Rect2i(dim.getLimitX() - 16, dim.getCenterY() - 5, 10, 10);
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            boolean ticked;
            super.render(mouseX, mouseY, delta);
            int x = this.button.getX();
            int y = this.button.getY();
            int w = x + this.button.getWidth();
            int h = y + this.button.getHeight();
            boolean enabled = this.option.isAvailable();
            boolean bl = ticked = enabled && (Boolean)this.option.getValue() != false;
            int color = enabled ? (ticked ? -7019309 : -1) : -5592406;
            if (ticked) {
                this.drawRect(x + 2, y + 2, w - 2, h - 2, color);
            }
            this.drawRectOutline(x, y, w, h, color);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.option.setValue((Boolean)this.option.getValue() == false);
                this.playClickSound();
                return true;
            }
            return false;
        }

        protected void drawRectOutline(int x, int y, int w, int h, int color) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.drawQuads(vertices -> {
                TickBoxControlElement.addQuad(vertices, x, y, w, y + 1, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, h - 1, w, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, y, x + 1, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, w - 1, y, w, h, a, r, g, b);
            });
        }
    }
}

