/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.sodium;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRHFactory;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.IRenderingRegistryExt;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RenderingRegistry.class}, remap=false)
public class MixinRenderingRegistry
implements IRenderingRegistryExt {
    @Shadow
    private Map<Integer, ISimpleBlockRenderingHandler> blockRenderers;
    private ThreadLocal<Map<Class<?>, Object>> THREAD_LOCAL_MAP = ThreadLocal.withInitial(Reference2ObjectOpenHashMap::new);

    @Override
    public ISimpleBlockRenderingHandler getISBRH(int modelId) {
        return this.blockRenderers.get(modelId);
    }

    @WrapOperation(method={"renderWorldBlock", "renderInventoryBlock", "renderItemAsFull3DBlock"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")})
    private Object getWrapped(Map<Integer, ISimpleBlockRenderingHandler> instance, Object modelId, Operation<ISimpleBlockRenderingHandler> original) {
        ISimpleBlockRenderingHandler mainThreadHandler = (ISimpleBlockRenderingHandler)original.call(new Object[]{instance, modelId});
        if (Thread.currentThread() != GLStateManager.getMainThread()) {
            ThreadSafeISBRH annotation = mainThreadHandler.getClass().getAnnotation(ThreadSafeISBRH.class);
            if (annotation != null && annotation.perThread()) {
                return this.THREAD_LOCAL_MAP.get().computeIfAbsent(mainThreadHandler.getClass(), k -> {
                    try {
                        return mainThreadHandler.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getCause());
                    }
                });
            }
            if (ThreadSafeISBRHFactory.class.isAssignableFrom(mainThreadHandler.getClass())) {
                return this.THREAD_LOCAL_MAP.get().computeIfAbsent(mainThreadHandler.getClass(), k -> ((ThreadSafeISBRHFactory)mainThreadHandler).newInstance());
            }
        }
        return mainThreadHandler;
    }
}

