/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.IBlockAccessWrapper;
import com.google.common.collect.Lists;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.BlockConduitBundle;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.BlockConduitFacade;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.config.Config;
import crazypants.util.RenderPassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
@ThreadSafeISBRH(perThread=false)
public class ConduitBundleRenderer
implements ISimpleBlockRenderingHandler {
    private static final ThreadLocal<BlockConduitFacade> facade = ThreadLocal.withInitial(() -> {
        try {
            return EnderIO.blockConduitFacade.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    });

    public ConduitBundleRenderer(float conduitScale) {
    }

    public ConduitBundleRenderer() {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
        EntityClientPlayerMP player;
        IConduitBundle bundle;
        boolean renderedFacade;
        boolean renderConduit;
        Tessellator tessellator = Tessellator.field_78398_a;
        int pass = RenderPassHelper.getBlockRenderPass();
        if (pass == 1) {
            tessellator.func_78374_a((double)x, (double)y, (double)z, 0.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, (double)z, 0.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, (double)z, 0.0, 0.0);
            tessellator.func_78374_a((double)x, (double)y, (double)z, 0.0, 0.0);
        }
        boolean bl = renderConduit = !(renderedFacade = this.renderFacade(x, y, z, pass, rb, bundle = (IConduitBundle)world.func_147438_o(x, y, z), player = Minecraft.func_71410_x().field_71439_g)) || ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player);
        if (bundle != null && renderConduit && (pass == 0 || rb.field_147840_d != null)) {
            BlockCoord loc = bundle.getLocation();
            float brightness = !Config.updateLightingWhenHidingFacades && bundle.hasFacade() && ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player) ? 1.572888E7f : (float)bundle.getEntity().func_145831_w().func_72802_i(loc.x, loc.y, loc.z, 0);
            this.renderConduits(bundle, x, y, z, 0.0f, brightness, rb);
            return true;
        }
        return renderedFacade || bundle != null && bundle.hasFacade() && !bundle.getFacadeId().func_149662_c();
    }

    private boolean renderFacade(int x, int y, int z, int pass, RenderBlocks rb, IConduitBundle bundle, EntityClientPlayerMP player) {
        boolean res = false;
        if (bundle == null) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (bundle.hasFacade()) {
            res = true;
            Block facadeId = bundle.getFacadeId();
            if (ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player)) {
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                bundle.setFacadeId(null, false);
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.WIRE_FRAME);
                BlockConduitFacade facb = facade.get();
                facb.setBlockOverride(bundle);
                facb.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (!rb.func_147744_b()) {
                    rb.func_147775_a((Block)facb);
                    rb.func_147784_q((Block)facb, x, y, z);
                }
                facb.setBlockOverride(null);
                bundle.setFacadeId(facadeId, false);
            } else if (facadeId != null) {
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.FULL);
                boolean isFacadeOpaque = facadeId.func_149662_c();
                if (isFacadeOpaque && pass == 0 || rb.func_147744_b() || !isFacadeOpaque && pass == 1) {
                    IBlockAccess origBa = rb.field_147845_a;
                    rb.field_147845_a = new FacadeAccessWrapper(origBa);
                    try {
                        rb.func_147805_b(facadeId, x, y, z);
                    }
                    catch (Exception e) {
                        rb.func_147757_a(IconUtil.errorTexture);
                        rb.func_147784_q(Blocks.field_150348_b, x, y, z);
                        rb.func_147757_a(null);
                    }
                    rb.field_147845_a = origBa;
                }
                res = isFacadeOpaque;
            }
        } else {
            bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.NONE);
        }
        return res;
    }

    public void renderConduits(IConduitBundle bundle, double x, double y, double z, float partialTick, float brightness, RenderBlocks rb) {
        if (bundle == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        CubeRenderer cr = CubeRenderer.get();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78372_c((float)x, (float)y, (float)z);
        HashSet<ForgeDirection> externals = new HashSet<ForgeDirection>();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ArrayList<BoundingBox> wireBounds = new ArrayList<BoundingBox>();
        for (IConduit con : bundle.getConduits()) {
            if (ConduitUtil.renderConduit((EntityPlayer)player, con)) {
                ConduitRenderer renderer = con.getRenderer();
                renderer.renderEntity(this, bundle, con, x, y, z, partialTick, brightness, rb);
                Set<ForgeDirection> extCons = con.getExternalConnections();
                Iterator iterator = extCons.iterator();
                while (iterator.hasNext()) {
                    ForgeDirection dir = (ForgeDirection)iterator.next();
                    if (con.getConnectionMode(dir) == ConnectionMode.DISABLED || con.getConnectionMode(dir) == ConnectionMode.NOT_SET) continue;
                    externals.add(dir);
                }
                continue;
            }
            if (con == null) continue;
            Collection<CollidableComponent> components = con.getCollidableComponents();
            for (CollidableComponent component : components) {
                wireBounds.add(component.bound);
            }
        }
        List<CollidableComponent> connectors = bundle.getConnectors();
        ArrayList rendered = Lists.newArrayList();
        for (int i = 0; i < connectors.size(); ++i) {
            CollidableComponent component = connectors.get(i);
            if (component.conduitType != null) {
                IConduit conduit = bundle.getConduit(component.conduitType);
                if (conduit == null) continue;
                if (ConduitUtil.renderConduit((EntityPlayer)player, component.conduitType)) {
                    if (rb.func_147744_b()) {
                        List<RaytraceResult> results = EnderIO.blockConduitBundle.doRayTraceAll(bundle.getWorld(), MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), EnderIO.proxy.getClientPlayer());
                        for (RaytraceResult r : results) {
                            if (r.component.conduitType != component.conduitType || rendered.contains(r.component)) continue;
                            rendered.add(r.component);
                            cr.render(component.bound, rb.field_147840_d, true);
                        }
                        continue;
                    }
                    tessellator.func_78380_c((int)brightness);
                    cr.render(component.bound, conduit.getTextureForState(component), true);
                    continue;
                }
                wireBounds.add(component.bound);
                continue;
            }
            if (ConduitUtil.getDisplayMode((EntityPlayer)player) != ConduitDisplayMode.ALL || rb.func_147744_b()) continue;
            IIcon tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
            cr.render(component.bound, tex);
        }
        BlockConduitFacade facb = facade.get();
        for (int i = 0; i < wireBounds.size(); ++i) {
            BoundingBox wireBound = (BoundingBox)wireBounds.get(i);
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.25f);
            cr.render(wireBound, facb.func_149691_a(0, 0));
        }
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        if (rb.field_147840_d == null) {
            for (ForgeDirection dir : externals) {
                this.renderExternalConnection(dir);
            }
        }
        tessellator.func_78372_c(-((float)x), -((float)y), -((float)z));
    }

    private void renderExternalConnection(ForgeDirection dir) {
        IIcon tex = EnderIO.blockConduitBundle.getConnectorIcon((Object)ConduitConnectorType.EXTERNAL);
        BoundingBox[] bbs = ConduitGeometryUtil.instance.getExternalConnectorBoundingBoxes(dir);
        CubeRenderer cr = CubeRenderer.get();
        for (int i = 0; i < bbs.length; ++i) {
            BoundingBox bb = bbs[i];
            cr.render(bb, tex, true);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public int getRenderId() {
        return BlockConduitBundle.rendererId;
    }

    public static class FacadeAccessWrapper
    extends IBlockAccessWrapper {
        public FacadeAccessWrapper(IBlockAccess ba) {
            super(ba);
        }

        public Block func_147439_a(int x, int y, int z) {
            TileConduitBundle tcb;
            Block fac;
            TileEntity te;
            Block res = super.func_147439_a(x, y, z);
            if (res == EnderIO.blockConduitBundle && (te = this.func_147438_o(x, y, z)) instanceof TileConduitBundle && (fac = (tcb = (TileConduitBundle)te).getFacadeId()) != null) {
                res = fac;
            }
            return res;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_72802_i(int var1, int var2, int var3, int var4) {
            return this.wrapped.func_72802_i(var1, var2, var3, var4);
        }

        public int func_72805_g(int x, int y, int z) {
            TileConduitBundle tcb;
            Block fac;
            TileEntity te;
            Block block = super.func_147439_a(x, y, z);
            if (block == EnderIO.blockConduitBundle && (te = this.func_147438_o(x, y, z)) instanceof TileConduitBundle && (fac = (tcb = (TileConduitBundle)te).getFacadeId()) != null) {
                return tcb.getFacadeMetadata();
            }
            return super.func_72805_g(x, y, z);
        }
    }
}

