/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityManager;

public class BlockManager
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon botIcon;

    public BlockManager() {
        super(Material.field_151573_f);
        this.func_149663_c("sfm.BlockMachineManager");
        this.func_149672_a(field_149777_j);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149711_c(2.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityManager();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xSide, float ySide, float zSide) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)StevesFactoryManager.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.sideIcon = register.func_94245_a("stevesfactory:manager_side");
        this.topIcon = register.func_94245_a("stevesfactory:manager_top");
        this.botIcon = register.func_94245_a("stevesfactory:manager_bot");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.botIcon;
        }
        if (side == 1) {
            return this.topIcon;
        }
        return this.sideIcon;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.updateInventories(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.updateInventories(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        this.updateInventories(world, x, y, z);
    }

    private void updateInventories(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityManager) {
            ((TileEntityManager)tileEntity).updateInventories();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (StevesFactoryManager.isDevelopmentEnvironment()) {
            System.out.println("Picked" + world.field_72995_K);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileEntityManager) {
                TileEntityManager manager = (TileEntityManager)te;
                if (manager.field_145851_c != x || manager.field_145848_d != y || manager.field_145849_e != z) {
                    return null;
                }
                ItemStack itemStack = super.getPickBlock(target, world, x, y, z);
                if (itemStack != null) {
                    NBTTagCompound tagCompound = itemStack.func_77978_p();
                    if (tagCompound == null) {
                        tagCompound = new NBTTagCompound();
                        itemStack.func_77982_d(tagCompound);
                    }
                    NBTTagCompound info = new NBTTagCompound();
                    tagCompound.func_74782_a("Manager", (NBTBase)info);
                    manager.writeContentToNBT(info, true);
                    System.out.println("write");
                }
                return itemStack;
            }
            System.out.println("failed to write");
            return null;
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        if (StevesFactoryManager.isDevelopmentEnvironment()) {
            System.out.println("Placed" + world.field_72995_K);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileEntityManager) {
                TileEntityManager manager = (TileEntityManager)te;
                if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Manager")) {
                    manager.readContentFromNBT(itemStack.func_77978_p().func_74775_l("Manager"), true);
                    System.out.println("read");
                } else {
                    System.out.println("no data");
                }
            }
        } else {
            super.func_149689_a(world, x, y, z, entity, itemStack);
        }
    }
}

