/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseGui;

public class BaseGuiLayout {

    public static class Grid
    extends BaseGui.Group {
        public int rowSpacing = 4;
        public int colSpacing = 4;
        int numRows;
        int numCols;
        BaseGui.Widget[][] grid;

        public Grid(int numCols, Object ... items) {
            this.numCols = numCols;
            this.numRows = (items.length + numCols - 1) / numCols;
            this.grid = new BaseGui.Widget[this.numRows][numCols];
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                int row = i / numCols;
                int col = i % numCols;
                BaseGui.Widget widget = null;
                if (item != null) {
                    widget = item instanceof String ? new Label((String)item) : (BaseGui.Widget)item;
                }
                this.grid[row][col] = widget;
                if (widget == null) continue;
                this.add(0, 0, widget);
            }
        }

        @Override
        public void layout() {
            int col;
            super.layout();
            int[] colWidths = new int[this.numCols];
            int[] rowHeights = new int[this.numRows];
            for (int row = 0; row < this.numRows; ++row) {
                for (col = 0; col < this.numCols; ++col) {
                    BaseGui.Widget widget = this.grid[row][col];
                    rowHeights[row] = Math.max(rowHeights[row], widget.height);
                    colWidths[col] = Math.max(colWidths[col], widget.width);
                }
            }
            int x = 0;
            for (col = 0; col < this.numCols; ++col) {
                if (col > 0) {
                    x += this.colSpacing;
                }
                int w = colWidths[col];
                for (int row = 0; row < this.numRows; ++row) {
                    BaseGui.Widget widget = this.grid[row][col];
                    if (widget == null) continue;
                    widget.left = x;
                }
                x += w;
            }
            this.width = x;
            int y = 0;
            for (int row = 0; row < this.numRows; ++row) {
                if (row > 0) {
                    y += this.rowSpacing;
                }
                int h = rowHeights[row];
                for (int col2 = 0; col2 < this.numCols; ++col2) {
                    BaseGui.Widget widget = this.grid[row][col2];
                    if (widget == null) continue;
                    widget.top = y + (h - widget.height) / 2;
                }
                y += h;
            }
            this.height = y;
        }
    }

    public static class Label
    extends BaseGui.Widget {
        public String text;

        public Label(String text) {
            super(Label.stringWidth(text), 7);
            this.text = text;
        }

        @Override
        public void draw(BaseGui.Screen scr, int mx, int my) {
            scr.drawString(this.text, 0, 0);
        }
    }
}

