/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.net.lenni0451.reflect.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import unilib.external.net.lenni0451.reflect.Fields;
import unilib.external.net.lenni0451.reflect.utils.FieldInitializer;

public class ObjectPrinter {
    private static final List<Class<?>> PRIMITIVE_CLASSES = FieldInitializer.init(new ArrayList(), list -> {
        list.add(Boolean.class);
        list.add(Byte.class);
        list.add(Short.class);
        list.add(Character.class);
        list.add(Integer.class);
        list.add(Long.class);
        list.add(Float.class);
        list.add(Double.class);
        list.add(String.class);
    });
    private static final List<Converter> CONVERTERS = FieldInitializer.init(new ArrayList(), list -> {
        list.add(new Converter(Class::isArray, (array, out, valueToString, includeSuper) -> {
            out.append(array.getClass().getComponentType().getSimpleName()).append("[]{");
            int size = Array.getLength(array);
            for (int i = 0; i < size; ++i) {
                Object value = Array.get(array, i);
                out.append((String)valueToString.apply(value)).append(", ");
            }
            if (size > 0) {
                out.setLength(out.length() - 2);
            }
            out.append("}");
        }));
        list.add(new Converter(Iterable.class::isAssignableFrom, (it, out, valueToString, includeSuper) -> {
            Iterable iterable = (Iterable)it;
            out.append(it.getClass().getSimpleName()).append("{");
            boolean hasElements = false;
            for (Object value : iterable) {
                hasElements = true;
                out.append((String)valueToString.apply(value)).append(", ");
            }
            if (hasElements) {
                out.setLength(out.length() - 2);
            }
            out.append("}");
        }));
        list.add(new Converter(Map.class::isAssignableFrom, (m, out, valueToString, includeSuper) -> {
            Map map = (Map)m;
            out.append(m.getClass().getSimpleName()).append("{");
            boolean hasEntries = false;
            for (Map.Entry entry : map.entrySet()) {
                hasEntries = true;
                out.append((String)valueToString.apply(entry.getKey())).append("=").append((String)valueToString.apply(entry.getValue())).append(", ");
            }
            if (hasEntries) {
                out.setLength(out.length() - 2);
            }
            out.append("}");
        }));
        list.add(new Converter(c -> true, (o, out, valueToString, includeSuper) -> {
            Field[] fields;
            out.append(o.getClass().getSimpleName()).append("{");
            for (Field field : fields = ObjectPrinter.getFields(o.getClass(), includeSuper)) {
                Object value = Fields.get(o, field);
                out.append(field.getName()).append("=").append((String)valueToString.apply(value)).append(", ");
            }
            if (fields.length > 0) {
                out.setLength(out.length() - 2);
            }
            out.append("}");
        }));
    });

    public static String toString(Object o) {
        return ObjectPrinter.toString(o, 0, false);
    }

    public static String toString(Object o, int depth, boolean includeSuper) {
        Optional<String> plainString = ObjectPrinter.plainToString(o);
        if (plainString.isPresent()) {
            return plainString.get();
        }
        StringBuilder out = new StringBuilder();
        Converter converter = CONVERTERS.stream().filter(conv -> ((Converter)conv).filter.test(o.getClass())).findFirst().orElse(null);
        if (converter == null) {
            throw new IllegalStateException("No converter found! This should never happen!");
        }
        converter.converter.convert(o, out, value -> {
            if (depth > 0) {
                return ObjectPrinter.toString(value, depth - 1, includeSuper);
            }
            return ObjectPrinter.plainToString(value).orElseGet(() -> String.valueOf(value));
        }, includeSuper);
        return out.toString();
    }

    private static Field[] getFields(Class<?> clazz, boolean includeSuper) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = clazz;
        while (true) {
            for (Field field : Fields.getDeclaredFields(current)) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            if (!includeSuper || current == null || Object.class.equals(current)) break;
            current = current.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    private static Optional<String> plainToString(Object o) {
        if (o == null) {
            return Optional.of("null");
        }
        if (PRIMITIVE_CLASSES.contains(o.getClass())) {
            String quote = o instanceof String ? "\"" : (o instanceof Character ? "'" : "");
            return Optional.of(quote + o + quote);
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface ConverterFunction {
        public void convert(Object var1, StringBuilder var2, Function<Object, String> var3, boolean var4);
    }

    private static class Converter {
        private final Predicate<Class<?>> filter;
        private final ConverterFunction converter;

        private Converter(Predicate<Class<?>> filter, ConverterFunction converter) {
            this.filter = filter;
            this.converter = converter;
        }
    }
}

