/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.utils.ConstructableData;
import blockrenderer6343.client.world.ObserverWorld;
import blockrenderer6343.integration.nei.StructureHacks;
import com.google.common.collect.Iterables;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;

public class GTConstructableScan
implements Runnable {
    private final Consumer<Long2ObjectMap<ObjectSet<IConstructable>>> resultCallback;
    private final ObjectSet<Pair<IConstructable, Collection<IStructureElement<IConstructable>[]>>> constructables;

    public GTConstructableScan(Consumer<Long2ObjectMap<ObjectSet<IConstructable>>> resultCallback, Collection<IConstructable> multiblocks) {
        this.resultCallback = resultCallback;
        this.constructables = GTConstructableScan.getStructurePairs(multiblocks);
    }

    private static ObjectSet<Pair<IConstructable, Collection<IStructureElement<IConstructable>[]>>> getStructurePairs(Collection<IConstructable> constructables) {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (IConstructable multi : constructables) {
            IStructureDefinition structure = multi.getStructureDefinition();
            if (structure instanceof StructureDefinition) {
                result.add((Object)Pair.of((Object)multi, ((StructureDefinition)structure).getStructures().values()));
                continue;
            }
            result.add((Object)Pair.of((Object)multi, Collections.emptySet()));
        }
        return result;
    }

    @Override
    public void run() {
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        ObjectOpenHashSet secondScan = new ObjectOpenHashSet();
        Object2ObjectOpenHashMap constructableData = new Object2ObjectOpenHashMap();
        ConstructableData data = new ConstructableData();
        for (Pair pair : this.constructables) {
            IConstructable multi = (IConstructable)pair.left();
            Collection structures = (Collection)pair.right();
            ObjectOpenHashSet checkedElements = new ObjectOpenHashSet();
            if (structures.isEmpty()) {
                secondScan.add((Object)multi);
                continue;
            }
            Iterator iterator = structures.iterator();
            while (iterator.hasNext()) {
                IStructureElement[] elementArray;
                for (IStructureElement element : elementArray = (IStructureElement[])iterator.next()) {
                    Iterable<ItemStack> stacks;
                    if (!checkedElements.add((Object)element) || (stacks = StructureHacks.getStacksForElement(multi, element, data)) == null || Iterables.isEmpty(stacks)) continue;
                    for (ItemStack stack : stacks) {
                        if (!StructureHacks.isSafeStack(stack)) continue;
                        ((ObjectSet)result.computeIfAbsent(BRUtil.hashStack(stack), k -> new ObjectOpenHashSet())).add((Object)multi);
                    }
                }
            }
            if (data.hasData()) {
                constructableData.put((Object)multi, (Object)data);
                data = new ConstructableData();
                continue;
            }
            if (structures.size() <= 1) continue;
            secondScan.add((Object)multi);
        }
        ObserverWorld world = new ObserverWorld();
        for (IConstructable multi : secondScan) {
            int tier = world.estimateTierFromConstructable(arg_0 -> GTConstructableScan.lambda$run$2((Long2ObjectMap)result, multi, arg_0), multi);
            if (tier <= 1) continue;
            data.setMaxTier(tier, "");
            constructableData.put((Object)multi, (Object)data);
            data = new ConstructableData();
        }
        ConstructableData.addConstructableData((Object2ObjectMap<IConstructable, ConstructableData>)constructableData);
        this.resultCallback.accept((Long2ObjectMap<ObjectSet<IConstructable>>)result);
    }

    private static /* synthetic */ void lambda$run$2(Long2ObjectMap result, IConstructable multi, ItemStack stack) {
        ((ObjectSet)result.computeIfAbsent(BRUtil.hashStack(stack), k -> new ObjectOpenHashSet())).add((Object)multi);
    }
}

