/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public class StructureDefinition<T>
implements IStructureDefinition<T> {
    private final Map<Character, IStructureElement<T>> elements;
    private final Map<String, String> shapes;
    private final Map<String, IStructureElement<T>[]> structures;
    private final Map<String, Set<Vec3Impl>> occupiedSpaces;

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    private StructureDefinition(Map<Character, IStructureElement<T>> elements, Map<String, String> shapes, Map<String, IStructureElement<T>[]> structures, Map<String, Set<Vec3Impl>> occupiedSpaces) {
        this.elements = elements;
        this.shapes = shapes;
        this.structures = structures;
        this.occupiedSpaces = occupiedSpaces;
    }

    public Map<Character, IStructureElement<T>> getElements() {
        return this.elements;
    }

    public Map<String, String> getShapes() {
        return this.shapes;
    }

    public Map<String, IStructureElement<T>[]> getStructures() {
        return this.structures;
    }

    @Override
    public IStructureElement<T>[] getStructureFor(String name) {
        IStructureElement<T>[] elements = this.structures.get(name);
        if (elements == null) {
            throw new NoSuchElementException(name);
        }
        return elements;
    }

    @Override
    public boolean isContainedInStructure(String name, int offsetA, int offsetB, int offsetC) {
        Set<Vec3Impl> occupiedSpace = this.occupiedSpaces.get(name);
        if (occupiedSpace == null) {
            throw new NoSuchElementException(name);
        }
        return occupiedSpace.contains(new Vec3Impl(offsetA, offsetB, offsetC));
    }

    public static class Builder<T> {
        private static final char A = '\ua000';
        private static final char B = '\ub000';
        private static final char C = '\uc000';
        private char d = (char)53248;
        private final Map<Vec3Impl, Character> navigates = new HashMap<Vec3Impl, Character>();
        private final Map<Character, IStructureElement<T>> elements = new HashMap<Character, IStructureElement<T>>();
        private final Map<String, String> shapes = new HashMap<String, String>();
        private final Map<String, Set<Vec3Impl>> occupiedSpaces = new HashMap<String, Set<Vec3Impl>>();

        private Builder() {
        }

        public Map<Character, IStructureElement<T>> getElements() {
            return this.elements;
        }

        public Map<String, String> getShapes() {
            return this.shapes;
        }

        public Builder<T> addShape(String name, String[][] structurePiece) {
            StringBuilder builder = new StringBuilder();
            if (structurePiece.length > 0) {
                for (String[] strings : structurePiece) {
                    if (strings.length > 0) {
                        for (String string : strings) {
                            builder.append(string).append('\ub000');
                        }
                        builder.setLength(builder.length() - 1);
                    }
                    builder.append('\uc000');
                }
                builder.setLength(builder.length() - 1);
            }
            HashSet<Vec3Impl> occupiedSpace = new HashSet<Vec3Impl>();
            int aa = 0;
            int bb = 0;
            int cc = 0;
            int a = 0;
            int b = 0;
            int c = 0;
            for (int i = 0; i < builder.length(); ++i) {
                int ch = builder.charAt(i);
                if (ch == 32) {
                    builder.setCharAt(i, '\ua000');
                    ch = 40960;
                } else if (ch == 126) {
                    builder.setCharAt(i, '\ua000');
                    ch = 40960;
                    occupiedSpace.add(Vec3Impl.getFromPool(aa, bb, cc));
                }
                if (ch == 40960) {
                    ++aa;
                    ++a;
                    continue;
                }
                if (ch == 45056) {
                    aa = 0;
                    a = 0;
                    ++bb;
                    ++b;
                    continue;
                }
                if (ch == 49152) {
                    aa = 0;
                    bb = 0;
                    a = 0;
                    b = 0;
                    ++c;
                    ++cc;
                    continue;
                }
                if (a != 0 || b != 0 || c != 0) {
                    Vec3Impl vec3 = new Vec3Impl(a, b, c);
                    Character navigate = this.navigates.get(vec3);
                    if (navigate == null) {
                        char c2 = this.d;
                        this.d = (char)(c2 + '\u0001');
                        navigate = Character.valueOf(c2);
                        this.navigates.put(vec3, navigate);
                        this.addElement(navigate, (IStructureElement<T>)StructureUtility.step(vec3));
                    }
                    builder.setCharAt(i - 1, navigate.charValue());
                    occupiedSpace.add(Vec3Impl.getFromPool(aa, bb, cc));
                    ++aa;
                    a = 0;
                    b = 0;
                    c = 0;
                    continue;
                }
                occupiedSpace.add(Vec3Impl.getFromPool(aa, bb, cc));
                ++aa;
            }
            this.occupiedSpaces.put(name, occupiedSpace);
            String built = builder.toString().replaceAll("[\\uA000\\uB000\\uC000]", "");
            if (built.contains("+")) {
                this.addElement('+', (IStructureElement<T>)StructureUtility.notAir());
            }
            if (built.contains("-")) {
                this.addElement('-', (IStructureElement<T>)StructureUtility.isAir());
            }
            this.shapes.put(name, built);
            return this;
        }

        @Deprecated
        public Builder<T> addElement(Character name, IStructureElement<T> structurePiece) {
            this.elements.putIfAbsent(name, structurePiece);
            return this;
        }

        public Builder<T> addElement(char name, IStructureElement<T> structurePiece) {
            this.elements.putIfAbsent(Character.valueOf(name), structurePiece);
            return this;
        }

        public IStructureDefinition<T> build() {
            Map<String, IStructureElement<T>[]> structures = this.compileStructureMap();
            return new StructureDefinition(new HashMap<Character, IStructureElement<T>>(this.elements), new HashMap<String, String>(this.shapes), structures, this.occupiedSpaces);
        }

        private Map<String, IStructureElement<T>[]> compileElementSetMap() {
            Set<Integer> missing = this.findMissing();
            if (missing.isEmpty()) {
                return this.shapes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IStructureElement[])((String)e.getValue()).chars().mapToObj(c -> Character.valueOf((char)c)).distinct().map(this.elements::get).toArray(IStructureElement[]::new)));
            }
            throw new RuntimeException("Missing Structure Element bindings for (chars as integers): " + Arrays.toString(missing.toArray()));
        }

        private Map<String, IStructureElement<T>[]> compileStructureMap() {
            Set<Integer> missing = this.findMissing();
            if (missing.isEmpty()) {
                return this.shapes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IStructureElement[])((String)e.getValue()).chars().mapToObj(c -> this.elements.get(Character.valueOf((char)c))).toArray(IStructureElement[]::new)));
            }
            throw new RuntimeException("Missing Structure Element bindings for (chars as integers): " + Arrays.toString(missing.toArray()));
        }

        private Set<Integer> findMissing() {
            return this.shapes.values().stream().flatMapToInt(CharSequence::chars).filter(i -> !this.elements.containsKey(Character.valueOf((char)i))).boxed().collect(Collectors.toSet());
        }
    }
}

