/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenCypress
extends WorldGenTree {
    public WorldGenCypress(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        float leafSpawn = this.height + 2;
        float bottom = 1.0f;
        float width = (float)this.height * this.randBetween(0.15f, 0.2f);
        if (width > 7.0f) {
            width = 7.0f;
        }
        float coneHeight = leafSpawn - bottom;
        while (leafSpawn > bottom) {
            float radius = (1.0f - (leafSpawn - bottom) / coneHeight) * (width - 1.0f) + 1.0f;
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius, 1, this.leaf, false);
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 2);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

