/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.tab;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.tab.ControlTabBar;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.craftgui.minecraft.control.ControlTabIcon;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;

public class ControlTab<T>
extends Control
implements ITooltip,
IControlValue<T> {
    protected T value;
    private final ControlTabBar<T> tabBar;

    public ControlTab(ControlTabBar<T> parent, float x, float y, float w, float h, T value) {
        super(parent, x, y, w, h);
        this.setValue(value);
        this.tabBar = parent;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                ControlTab.this.callEvent(new EventValueChanged(ControlTab.this.getWidget(), ControlTab.this.getValue()));
            }
        });
    }

    @Override
    public void onRenderBackground() {
        CraftGUITexture texture = CraftGUITexture.TabDisabled;
        if (this.isMouseOver()) {
            texture = CraftGUITexture.TabHighlighted;
        } else if (this.isCurrentSelection()) {
            texture = CraftGUITexture.Tab;
        }
        Texture lTexture = CraftGUI.render.getTexture((Object)texture);
        Position position = this.getTabPosition();
        Texture iTexture = lTexture.crop(position, 8.0f);
        IArea area = this.getArea();
        if (texture == CraftGUITexture.TabDisabled) {
            if (position == Position.TOP || position == Position.LEFT) {
                area.setPosition(area.getPosition().sub(new IPoint(4 * position.x(), 4 * position.y())));
                area.setSize(area.getSize().add(new IPoint(4 * position.x(), 4 * position.y())));
            } else {
                area.setSize(area.getSize().sub(new IPoint(4 * position.x(), 4 * position.y())));
            }
        }
        CraftGUI.render.texture(iTexture, area);
        ControlTab controlTab = this;
        if (controlTab instanceof ControlTabIcon) {
            ControlTabIcon icon = (ControlTabIcon)controlTab;
            ControlItemDisplay item = (ControlItemDisplay)this.getWidgets().get(0);
            if (texture == CraftGUITexture.TabDisabled) {
                item.setColor(-1431655766);
            } else {
                item.setColor(-1);
            }
            if (icon.hasOutline()) {
                iTexture = CraftGUI.render.getTexture((Object)CraftGUITexture.TabOutline);
                iTexture = iTexture.crop(position, 8.0f);
                CraftGUI.render.color(icon.getOutlineColor());
                CraftGUI.render.texture(iTexture, area.inset(2));
            }
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        String name = this.getName();
        if (name != null && !name.isEmpty()) {
            tooltip.add(this.getName());
        }
        if (this.value instanceof ITooltip) {
            ((ITooltip)this.value).getTooltip(tooltip);
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public Position getTabPosition() {
        return this.tabBar.position;
    }

    public String getName() {
        return this.value.toString();
    }

    public boolean isCurrentSelection() {
        return this.getValue() != null && this.getValue().equals(this.tabBar.getValue());
    }
}

