/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import org.jetbrains.annotations.Nullable;

public class DraggableWidget<W extends DraggableWidget<W>>
extends Widget<W>
implements IDraggable {
    private boolean moving = false;
    private int relativeClickX;
    private int relativeClickY;
    private final Area movingArea = this.getArea().createCopy();
    private int realX;
    private int realY;

    @Override
    public void drawMovingState(ModularGuiContext context, float partialTicks) {
        WidgetTree.drawTree(this, context, true, true);
    }

    @Override
    public boolean onDragStart(int mouseButton) {
        if (mouseButton == 0) {
            this.realX = this.getContext().transformX(0.0f, 0.0f) - this.getParentArea().x;
            this.realY = this.getContext().transformY(0.0f, 0.0f) - this.getParentArea().y;
            this.movingArea.x = this.realX;
            this.movingArea.y = this.realY;
            this.relativeClickX = this.getContext().getAbsMouseX() - this.realX;
            this.relativeClickY = this.getContext().getAbsMouseY() - this.realY;
            return true;
        }
        return false;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            ((Flex)this.flex().top(this.getContext().getAbsMouseY() - this.relativeClickY)).left(this.getContext().getAbsMouseX() - this.relativeClickX);
            this.movingArea.x = this.getArea().x;
            this.movingArea.y = this.getArea().y;
            this.scheduleResize();
        }
    }

    @Override
    public void onDrag(int mouseButton, long timeSinceLastClick) {
        this.movingArea.x = this.getContext().getAbsMouseX() - this.relativeClickX;
        this.movingArea.y = this.getContext().getAbsMouseY() - this.relativeClickY;
    }

    @Override
    @Nullable
    public Area getMovingArea() {
        return this.movingArea;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.setEnabled(!moving);
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.isInside(stack, x, y)) {
            widgets.add(this, stack.peek());
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.isMoving()) {
            stack.translate(-this.getArea().rx, -this.getArea().ry);
            stack.translate(-this.realX, -this.realY);
            stack.translate(this.movingArea.x, this.movingArea.y);
        }
    }
}

