/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IJsonSerializable;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.Circle;
import com.cleanroommc.modularui.drawable.DrawableStack;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.utils.ObjectList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DrawableSerialization
implements JsonSerializer<IDrawable>,
JsonDeserializer<IDrawable> {
    private static final Map<String, Function<JsonObject, ? extends IDrawable>> DRAWABLE_TYPES = new Object2ObjectOpenHashMap();
    private static final Map<Class<? extends IDrawable>, String> REVERSE_DRAWABLE_TYPES = new Object2ObjectOpenHashMap();
    private static final Map<String, UITexture> TEXTURES = new Object2ObjectOpenHashMap();
    private static final Map<UITexture, String> REVERSE_TEXTURES = new Object2ObjectOpenHashMap();

    public static void registerTexture(String s, UITexture texture) {
        TEXTURES.put(s, texture);
        REVERSE_TEXTURES.put(texture, s);
    }

    public static UITexture getTexture(String s) {
        return TEXTURES.get(s);
    }

    public static String getTextureId(UITexture texture) {
        return REVERSE_TEXTURES.get(texture);
    }

    public static <T extends IDrawable & IJsonSerializable> void registerDrawableType(String id, Class<T> type, Function<@NotNull JsonObject, @NotNull T> creator) {
        if (DRAWABLE_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Drawable type '" + id + "' already exists!");
        }
        DRAWABLE_TYPES.put(id, creator);
        if (type != null) {
            REVERSE_DRAWABLE_TYPES.put(type, id);
        }
    }

    @ApiStatus.Internal
    public static void init() {
        DrawableSerialization.registerDrawableType("texture", UITexture.class, UITexture::parseFromJson);
        DrawableSerialization.registerDrawableType("color", Rectangle.class, json -> new Rectangle());
        DrawableSerialization.registerDrawableType("rectangle", Rectangle.class, json -> new Rectangle());
        DrawableSerialization.registerDrawableType("ellipse", Circle.class, json -> new Circle());
        DrawableSerialization.registerDrawableType("item", ItemDrawable.class, ItemDrawable::ofJson);
        DrawableSerialization.registerDrawableType("icon", Icon.class, Icon::ofJson);
    }

    public static IDrawable deserialize(JsonElement json) {
        return JsonHelper.deserialize(json, IDrawable.class);
    }

    public static JsonElement serialize(IDrawable drawable) {
        return JsonHelper.serialize(drawable);
    }

    public IDrawable deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (element.isJsonNull()) {
            return IDrawable.EMPTY;
        }
        if (element.isJsonPrimitive()) {
            if ("empty".equals(element.getAsString()) || "null".equals(element.getAsString())) {
                return IDrawable.EMPTY;
            }
            if ("none".equals(element.getAsString())) {
                return IDrawable.NONE;
            }
        }
        if (element.isJsonArray()) {
            ArrayList<IDrawable> list = new ArrayList<IDrawable>();
            for (JsonElement element1 : element.getAsJsonArray()) {
                IDrawable drawable = (IDrawable)context.deserialize(element1, IDrawable.class);
                if (drawable == null) continue;
                list.add(drawable);
            }
            if (list.isEmpty()) {
                return IDrawable.EMPTY;
            }
            if (list.size() == 1) {
                return (IDrawable)list.get(0);
            }
            return new DrawableStack(list.toArray(new IDrawable[0]));
        }
        if (!element.isJsonObject()) {
            ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Drawable json should be an object or an array."));
            return IDrawable.EMPTY;
        }
        JsonObject json = element.getAsJsonObject();
        if (json.entrySet().isEmpty()) {
            return IDrawable.EMPTY;
        }
        String type = JsonHelper.getString(json, "empty", "type");
        if ("text".equals(type)) {
            IKey key = DrawableSerialization.parseText(json);
            key.loadFromJson(json);
            return key;
        }
        if (!DRAWABLE_TYPES.containsKey(type)) {
            ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Drawable type '" + type + "' is either not json serializable!"));
            return IDrawable.EMPTY;
        }
        IDrawable drawable = DRAWABLE_TYPES.get(type).apply(json);
        ((IJsonSerializable)((Object)drawable)).loadFromJson(json);
        return drawable;
    }

    public JsonElement serialize(IDrawable src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == IDrawable.EMPTY) {
            return JsonNull.INSTANCE;
        }
        if (src == IDrawable.NONE) {
            return new JsonPrimitive("none");
        }
        if (src instanceof DrawableStack) {
            DrawableStack drawableStack = (DrawableStack)src;
            JsonArray jsonArray = new JsonArray();
            for (IDrawable drawable : drawableStack.getDrawables()) {
                jsonArray.add(JsonHelper.serialize(drawable));
            }
            return jsonArray;
        }
        JsonObject json = new JsonObject();
        if (src instanceof IKey) {
            IKey key = (IKey)src;
            json.addProperty("type", "text");
            json.addProperty("text", key.getFormatted());
        } else {
            Class<?> type;
            if (!(src instanceof IJsonSerializable)) {
                throw new IllegalArgumentException("Can't serialize IDrawable which doesn't implement IJsonSerializable!");
            }
            String key = REVERSE_DRAWABLE_TYPES.get(type);
            for (type = src.getClass(); key == null && type != null && type != Object.class; type = type.getSuperclass()) {
                key = REVERSE_DRAWABLE_TYPES.get(type);
            }
            if (key == null) {
                ModularUI.LOGGER.error("Serialization of drawable {} failed, because a key for the type could not be found!", new Object[]{src.getClass().getSimpleName()});
                return JsonNull.INSTANCE;
            }
            json.addProperty("type", key);
            if (!((IJsonSerializable)((Object)src)).saveToJson(json)) {
                ModularUI.LOGGER.error("Serialization of drawable {} failed!", new Object[]{src.getClass().getSimpleName()});
            }
        }
        return json;
    }

    private static IKey parseText(JsonObject json) throws JsonParseException {
        JsonElement element = JsonHelper.getJsonElement(json, "text", "string", "key");
        if (element == null || element.isJsonNull()) {
            return IKey.str("No text found!");
        }
        if (element.isJsonPrimitive()) {
            String s = element.getAsString();
            if (s.startsWith("I18n:")) {
                return IKey.lang(s.substring(5));
            }
            return JsonHelper.getBoolean(json, false, "lang", "translate") ? IKey.lang(s) : IKey.str(s);
        }
        if (element.isJsonArray()) {
            ObjectList.ObjectArrayList strings = ObjectList.create();
            for (JsonElement element1 : element.getAsJsonArray()) {
                strings.add(DrawableSerialization.parseText(element1));
            }
            strings.trim();
            return IKey.comp((IKey[])strings.elements());
        }
        throw new JsonParseException("");
    }

    private static IKey parseText(JsonElement element) throws JsonParseException {
        if (element.isJsonPrimitive()) {
            String s = element.getAsString();
            if (s.startsWith("I18n:")) {
                return IKey.lang(s.substring(5));
            }
            return IKey.str(s);
        }
        if (element.isJsonObject()) {
            return DrawableSerialization.parseText(element.getAsJsonObject());
        }
        throw new JsonParseException("");
    }

    private static IKey parseKeyFromJson(JsonObject json, Function<String, IKey> keyFunction) {
        return keyFunction.apply(JsonHelper.getString(json, "No text found!", "text", "string", "key"));
    }
}

