/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.LinkedHashSet;
import java.util.Set;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.IKeyListener;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.control.IControlComponent;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.ComponentExceptionHandler;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.event.component.SpaceChangeEvent;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.util.MouseButton;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public abstract class UIComponent<T extends UIComponent>
implements ITransformable.Position<T>,
ITransformable.Size<T>,
ITransformable.Alpha,
IKeyListener {
    private static final ComponentExceptionHandler exceptionHandler = new ComponentExceptionHandler();
    public static final int INHERITED = 0;
    private final MalisisGui gui;
    private final GuiRenderer renderer;
    private final Set<IControlComponent> controlComponents;
    protected int x;
    protected int y;
    protected int zIndex = 0;
    protected int anchor = Anchor.NONE;
    protected int width = 0;
    protected int height = 0;
    private EventBus bus;
    protected UIComponent parent;
    protected String name;
    protected UITooltip tooltip;
    protected boolean visible = true;
    protected boolean disabled = false;
    protected boolean hovered = false;
    protected boolean focused = false;
    protected GuiShape shape;
    protected RenderParameters rp;
    protected GuiIcon icon;
    protected int alpha = 255;
    private Object data;

    public UIComponent(MalisisGui gui) {
        this.gui = gui;
        this.renderer = gui.getRenderer();
        this.bus = new EventBus((SubscriberExceptionHandler)exceptionHandler);
        this.bus.register((Object)this);
        this.controlComponents = new LinkedHashSet<IControlComponent>();
        this.rp = new RenderParameters();
        this.shape = new SimpleGuiShape();
    }

    public MalisisGui getGui() {
        return this.gui;
    }

    public GuiRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public T setPosition(int x, int y) {
        return this.setPosition(x, y, this.anchor);
    }

    public T setPosition(int x, int y, int anchor) {
        int oldX = this.x;
        int oldY = this.y;
        int oldAnchor = this.anchor;
        this.x = x;
        this.y = y;
        this.anchor = anchor;
        if (!this.fireEvent(new SpaceChangeEvent.PositionChangeEvent<UIComponent>(this, x, y, anchor))) {
            this.x = oldX;
            this.y = oldY;
            this.anchor = oldAnchor;
            return (T)this;
        }
        return (T)this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public T setZIndex(int zIndex) {
        this.zIndex = zIndex;
        return (T)this;
    }

    public int getZIndex() {
        return this.zIndex == 0 ? (this.parent != null ? this.parent.getZIndex() : 0) : this.zIndex;
    }

    public T setAnchor(int anchor) {
        int oldAnchor = this.anchor;
        this.anchor = anchor;
        if (!this.fireEvent(new SpaceChangeEvent.PositionChangeEvent<UIComponent>(this, this.x, this.y, anchor))) {
            this.anchor = oldAnchor;
            return (T)this;
        }
        return (T)this;
    }

    public int getAnchor() {
        return this.anchor;
    }

    @Override
    public T setSize(int width, int height) {
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = width;
        this.height = height;
        if (!this.fireEvent(new SpaceChangeEvent.SizeChangeEvent<UIComponent>(this, width, height))) {
            this.width = oldWidth;
            this.height = oldHeight;
            return (T)this;
        }
        return (T)this;
    }

    public int getRawWidth() {
        return this.width;
    }

    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        if (this.parent == null) {
            return 0;
        }
        int w = this.parent.getWidth() + this.width;
        if (this.parent instanceof UIContainer) {
            w -= 2 * ((UIContainer)this.parent).getHorizontalPadding();
        }
        return w;
    }

    public boolean isRelativeWidth() {
        return this.width <= 0;
    }

    public int getRawHeight() {
        return this.height;
    }

    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        if (this.parent == null) {
            return 0;
        }
        int h = this.parent.getHeight() + this.height;
        if (this.parent instanceof UIContainer) {
            h -= 2 * ((UIContainer)this.parent).getVerticalPadding();
        }
        return h;
    }

    public boolean isRelativeHeight() {
        return this.height <= 0;
    }

    public void setHovered(boolean hovered) {
        boolean flag;
        boolean bl = flag = this.hovered != hovered;
        if (!(flag |= MalisisGui.setHoveredComponent(this, hovered))) {
            return;
        }
        this.hovered = hovered;
        this.fireEvent(new StateChangeEvent.HoveredStateChange<UIComponent>(this, hovered));
        if (this.tooltip != null && hovered) {
            this.tooltip.animate();
        }
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setFocused(boolean focused) {
        boolean flag;
        if (this.isDisabled()) {
            return;
        }
        boolean bl = flag = this.focused != focused;
        if (!(flag |= MalisisGui.setFocusedComponent(this, focused))) {
            return;
        }
        this.focused = focused;
        this.fireEvent(new StateChangeEvent.FocusStateChange<UIComponent>(this, focused));
    }

    public boolean isFocused() {
        return this.focused;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
        this.fireEvent(new ContentUpdateEvent<UIComponent>(this));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public T setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return (T)this;
        }
        if (!this.fireEvent(new StateChangeEvent.VisibleStateChange<UIComponent>(this, visible))) {
            return (T)this;
        }
        this.visible = visible;
        if (!visible) {
            this.setHovered(false);
            this.setFocused(false);
        }
        return (T)this;
    }

    public boolean isDisabled() {
        return this.disabled || this.parent != null && this.parent.isDisabled();
    }

    public T setDisabled(boolean disabled) {
        if (this.isDisabled() == disabled) {
            return (T)this;
        }
        if (!this.fireEvent(new StateChangeEvent.DisabledStateChange<UIComponent>(this, disabled))) {
            return (T)this;
        }
        this.disabled = disabled;
        if (disabled) {
            this.setHovered(false);
            this.setFocused(false);
        }
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public UITooltip getTooltip() {
        return this.tooltip;
    }

    public T setTooltip(UITooltip tooltip) {
        this.tooltip = tooltip;
        return (T)this;
    }

    public T setTooltip(String text) {
        this.setTooltip(new UITooltip(this.getGui(), text));
        return (T)this;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        if (this.getParent() == null) {
            return this.alpha;
        }
        return Math.min(this.alpha, this.parent.getAlpha());
    }

    public void attachData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public T register(Object object) {
        this.bus.register(object);
        return (T)this;
    }

    public T unregister(Object object) {
        this.bus.unregister(object);
        return (T)this;
    }

    public boolean fireEvent(ComponentEvent event) {
        this.bus.post((Object)event);
        return !event.isCancelled();
    }

    public boolean onMouseMove(int lastX, int lastY, int x, int y) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onMouseMove(lastX, lastY, x, y) : false;
    }

    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onButtonPress(x, y, button) : false;
    }

    public boolean onButtonRelease(int x, int y, MouseButton button) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onButtonRelease(x, y, button) : false;
    }

    public boolean onClick(int x, int y) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onClick(x, y) : false;
    }

    public boolean onRightClick(int x, int y) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onRightClick(x, y) : false;
    }

    public boolean onDoubleClick(int x, int y, MouseButton button) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onDoubleClick(x, y, button) : false;
    }

    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (this.isDisabled()) {
            return false;
        }
        return this.parent != null ? this.parent.onDrag(lastX, lastY, x, y, button) : false;
    }

    public boolean onScrollWheel(int x, int y, int delta) {
        if (this.isDisabled()) {
            return false;
        }
        for (IControlComponent c : this.controlComponents) {
            if (!c.onScrollWheel(x, y, delta)) continue;
            return true;
        }
        return this.parent != null && !(this instanceof IControlComponent) ? this.parent.onScrollWheel(x, y, delta) : false;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (this.isDisabled()) {
            return false;
        }
        for (IControlComponent c : this.controlComponents) {
            if (!c.onKeyTyped(keyChar, keyCode)) continue;
            return true;
        }
        return this.parent != null && !(this instanceof IControlComponent) ? this.parent.onKeyTyped(keyChar, keyCode) : false;
    }

    public boolean isInsideBounds(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        return x >= this.screenX() && x <= this.screenX() + this.getWidth() && y >= this.screenY() && y <= this.screenY() + this.getHeight();
    }

    public UIComponent getComponentAt(int x, int y) {
        for (IControlComponent c : this.controlComponents) {
            UIComponent component = c.getComponentAt(x, y);
            if (component == null) continue;
            return component;
        }
        return this.isInsideBounds(x, y) ? this : null;
    }

    public int relativeX(int x) {
        return x - this.screenX();
    }

    public int relativeY(int y) {
        return y - this.screenY();
    }

    public int componentX(UIComponent component) {
        int x = component.getX();
        int w = this.getWidth() - component.getWidth();
        int a = Anchor.horizontal(component.getAnchor());
        if (a == Anchor.CENTER) {
            x += w / 2;
        } else if (a == Anchor.RIGHT) {
            x += w;
        }
        return x;
    }

    public int componentY(UIComponent component) {
        int y = component.getY();
        int h = this.getHeight() - component.getHeight();
        int a = Anchor.vertical(component.getAnchor());
        if (a == Anchor.MIDDLE) {
            y += h / 2;
        } else if (a == Anchor.BOTTOM) {
            y += h;
        }
        return y;
    }

    public int parentX() {
        return this.getParent() != null ? this.getParent().componentX(this) : this.getX();
    }

    public int parentY() {
        return this.getParent() != null ? this.getParent().componentY(this) : this.getY();
    }

    public int screenX() {
        int x = this.parentX();
        if (this.getParent() != null) {
            x += this.getParent().screenX();
        }
        return x;
    }

    public int screenY() {
        int y = this.parentY();
        if (this.getParent() != null) {
            y += this.getParent().screenY();
        }
        return y;
    }

    public void addControlComponent(IControlComponent component) {
        this.controlComponents.add(component);
        component.setParent(this);
    }

    public void removeControlComponent(IControlComponent component) {
        if (component.getParent() != this) {
            return;
        }
        this.controlComponents.remove(component);
        component.setParent(null);
    }

    public void removeAllControlComponents() {
        for (IControlComponent component : this.controlComponents) {
            component.setParent(null);
        }
        this.controlComponents.clear();
    }

    public void onAddedToScreen() {
        if (this.width <= 0 || this.height <= 0) {
            this.fireEvent(new SpaceChangeEvent.SizeChangeEvent<UIComponent>(this, this.getWidth(), this.getHeight()));
        }
    }

    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        ClipArea area;
        if (!this.isVisible()) {
            return;
        }
        if (this.shape != null) {
            this.shape.resetState();
            this.shape.setSize(this.getWidth(), this.getHeight());
        }
        if (this.rp != null) {
            this.rp.reset();
        }
        GL11.glPushAttrib((int)1048575);
        if (this.getAlpha() < 255) {
            GL11.glBlendFunc((int)32771, (int)32772);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.getAlpha() / 255.0f));
        }
        renderer.currentComponent = this;
        this.drawBackground(renderer, mouseX, mouseY, partialTick);
        renderer.next();
        renderer.currentComponent = this;
        ClipArea clipArea = area = this instanceof IClipable ? ((IClipable)((Object)this)).getClipArea() : null;
        if (area != null) {
            renderer.startClipping(area);
        }
        this.drawForeground(renderer, mouseX, mouseY, partialTick);
        if (area != null) {
            renderer.endClipping(area);
        }
        renderer.next();
        for (IControlComponent c : this.controlComponents) {
            c.draw(renderer, mouseX, mouseY, partialTick);
        }
        GL11.glPopAttrib();
    }

    public String getPropertyString() {
        return "P=" + (this.parent != null ? this.parent.getClass().getSimpleName() : "null") + " | " + this.width + "x" + this.height + "@" + this.x + "," + this.y + " | C=" + this.parentX() + "," + this.parentY() + " | S=" + this.screenX() + "," + this.screenY();
    }

    public String toString() {
        return (this.name == null ? this.getClass().getSimpleName() : this.name) + " [" + this.getPropertyString() + "]";
    }

    public abstract void drawBackground(GuiRenderer var1, int var2, int var3, float var4);

    public abstract void drawForeground(GuiRenderer var1, int var2, int var3, float var4);
}

