/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import java.util.List;
import logisticspipes.network.IReadListObject;
import logisticspipes.network.IWriteListObject;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;

public abstract class ListSyncPacket<E>
extends CoordinatesPacket
implements IWriteListObject<E>,
IReadListObject<E> {
    private List<E> list;

    public ListSyncPacket(int id, int x, int y, int z) {
        super(id);
        this.setPosX(x);
        this.setPosY(y);
        this.setPosZ(z);
    }

    public ListSyncPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeList(this.list, this);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.list = data.readList(this);
    }

    @Override
    public abstract ListSyncPacket<E> template();

    public ListSyncPacket<E> setList(List<E> list) {
        this.list = list;
        return this;
    }

    protected List<E> getList() {
        return this.list;
    }
}

