/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.storage.data.IAEFluidStack;
import com.glodblock.github.util.ModAndClassUtil;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public final class RenderUtil {
    public static void renderItemIcon(IIcon icon, double size, double z, float nx, float ny, float nz) {
        RenderUtil.renderItemIcon(icon, 0.0, 0.0, size, size, z, nx, ny, nz);
    }

    public static void renderItemIcon(IIcon icon, double xStart, double yStart, double xEnd, double yEnd, double z, float nx, float ny, float nz) {
        if (icon == null) {
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78375_b(nx, ny, nz);
        if (nz > 0.0f) {
            tess.func_78374_a(xStart, yStart, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tess.func_78374_a(xEnd, yStart, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tess.func_78374_a(xEnd, yEnd, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tess.func_78374_a(xStart, yEnd, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        } else {
            tess.func_78374_a(xStart, yEnd, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tess.func_78374_a(xEnd, yEnd, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tess.func_78374_a(xEnd, yStart, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tess.func_78374_a(xStart, yStart, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        }
        tess.func_78381_a();
    }

    public static void renderFluidIntoGui(Gui gui, int x, int y, int width, int height, @Nullable IAEFluidStack aeFluidStack, int capacity) {
        if (aeFluidStack != null) {
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int hi = (int)((double)height * ((double)aeFluidStack.getStackSize() / (double)capacity));
            if (aeFluidStack.getStackSize() > 0L && hi > 0) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                IIcon fluidIcon = aeFluidStack.getFluid().getStillIcon();
                if (ModAndClassUtil.HODGEPODGE && fluidIcon instanceof IPatchedTextureAtlasSprite) {
                    ((IPatchedTextureAtlasSprite)fluidIcon).markNeedsAnimationUpdate();
                }
                GL11.glColor3f((float)((float)(aeFluidStack.getFluid().getColor() >> 16 & 0xFF) / 255.0f), (float)((float)(aeFluidStack.getFluid().getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(aeFluidStack.getFluid().getColor() & 0xFF) / 255.0f));
                for (int th = 0; th <= hi && hi - th > 0; th += 16) {
                    gui.func_94065_a(x, y + height - Math.min(16, hi - th) - th, fluidIcon, width, Math.min(16, hi - th));
                }
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static List<String> listFormattedStringToWidth(String str) {
        return Minecraft.func_71410_x().field_71466_p.func_78271_c(str, 150);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

