/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.shaders;

import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLContext;

public class ArraysHelper {
    public static IArrayMethods methods;

    static void initialize() {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (GLArrayMethods.isSupported(caps)) {
            methods = new GLArrayMethods();
        } else if (ARBArrayMethods.isSupported(caps)) {
            methods = new ARBArrayMethods();
        }
    }

    public static boolean isSupported() {
        return methods != null;
    }

    public static IArrayMethods methods() {
        return methods;
    }

    static {
        ArraysHelper.initialize();
    }

    private static class ARBArrayMethods
    implements IArrayMethods {
        private ARBArrayMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.GL_ARB_instanced_arrays && caps.GL_ARB_vertex_array_object;
        }

        @Override
        public int glGenVertexArrays() {
            return ARBVertexArrayObject.glGenVertexArrays();
        }

        @Override
        public void glBindVertexArray(int array) {
            ARBVertexArrayObject.glBindVertexArray((int)array);
        }

        @Override
        public void glVertexAttribDivisor(int index, int divisor) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
        }

        @Override
        public void glDrawArraysInstanced(int mode, int first, int count, int primcount) {
            ARBDrawInstanced.glDrawArraysInstancedARB((int)mode, (int)first, (int)count, (int)primcount);
        }
    }

    private static class GLArrayMethods
    implements IArrayMethods {
        private GLArrayMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.OpenGL33;
        }

        @Override
        public int glGenVertexArrays() {
            return GL30.glGenVertexArrays();
        }

        @Override
        public void glBindVertexArray(int array) {
            GL30.glBindVertexArray((int)array);
        }

        @Override
        public void glVertexAttribDivisor(int index, int divisor) {
            GL33.glVertexAttribDivisor((int)index, (int)divisor);
        }

        @Override
        public void glDrawArraysInstanced(int mode, int first, int count, int primcount) {
            GL31.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)primcount);
        }
    }

    public static interface IArrayMethods {
        public int glGenVertexArrays();

        public void glBindVertexArray(int var1);

        public void glVertexAttribDivisor(int var1, int var2);

        public void glDrawArraysInstanced(int var1, int var2, int var3, int var4);
    }
}

