/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.pipes;

import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeCosmetic;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeBase
implements IPipe,
IPipeCosmetic {
    public String type;

    public PipeBase(String type) {
        this.type = type;
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        ArrayList<ForgeDirection> results = new ArrayList<ForgeDirection>();
        for (ForgeDirection d : TNHelper.randomDirections()) {
            if (d == dir.getOpposite() || !TNHelper.canOutput(world, x, y, z, d) || !TNHelper.canInput(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite())) continue;
            results.add(d);
        }
        return results;
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        if (pipe == null) {
            return true;
        }
        boolean advance = true;
        for (ForgeDirection d : TNHelper.randomDirections()) {
            if (!pipe.shouldConnectToTile(world, x, y, z, d) || buffer.transfer(world.func_147438_o(x + d.offsetX, y + d.offsetY, z + d.offsetZ), d.getOpposite(), pipe, x, y, z, dir)) continue;
            advance = false;
        }
        return advance;
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return true;
    }

    @Override
    public int limitTransfer(TileEntity dest, ForgeDirection side, INodeBuffer buffer) {
        return -1;
    }

    @Override
    public IInventory getFilterInventory(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return TNHelper.isValidTileEntity(world, x, y, z, dir);
    }

    @Override
    public IIcon baseTexture() {
        return BlockTransferPipe.pipes;
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        if (blocked) {
            return BlockTransferPipe.pipes_1way;
        }
        return BlockTransferPipe.pipes;
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return BlockTransferPipe.pipes;
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return BlockTransferPipe.pipes_nozzle;
    }

    @Override
    public String getPipeType() {
        return this.type;
    }

    @Override
    public float baseSize() {
        return 0.125f;
    }
}

