/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.compat.mojang.CompatMathHelper;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.StructBuffer;
import org.lwjgl.MemoryUtil;

public abstract class ChunkDrawCallBatcher
extends StructBuffer {
    protected final int capacity;
    protected boolean isBuilding;
    protected int count;
    protected int arrayLength;

    protected ChunkDrawCallBatcher(int capacity) {
        super(CompatMathHelper.smallestEncompassingPowerOfTwo(capacity), 16);
        this.capacity = capacity;
    }

    public static ChunkDrawCallBatcher create(int capacity) {
        return SodiumClientMod.isDirectMemoryAccessEnabled() ? new UnsafeChunkDrawCallBatcher(capacity) : new NioChunkDrawCallBatcher(capacity);
    }

    public void begin() {
        this.isBuilding = true;
        this.count = 0;
        this.arrayLength = 0;
        this.buffer.limit(this.buffer.capacity());
    }

    public void end() {
        this.isBuilding = false;
        this.arrayLength = this.count * this.stride;
        this.buffer.limit(this.arrayLength);
        this.buffer.position(0);
    }

    public boolean isBuilding() {
        return this.isBuilding;
    }

    public abstract void addIndirectDrawCall(int var1, int var2, int var3, int var4);

    public int getCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public static class UnsafeChunkDrawCallBatcher
    extends ChunkDrawCallBatcher {
        private final long basePointer;
        private long writePointer;

        public UnsafeChunkDrawCallBatcher(int capacity) {
            super(capacity);
            this.basePointer = MemoryUtil.getAddress((ByteBuffer)this.buffer);
        }

        @Override
        public void begin() {
            super.begin();
            this.writePointer = this.basePointer;
        }

        @Override
        public void addIndirectDrawCall(int first, int count, int baseInstance, int instanceCount) {
            if (this.count++ >= this.capacity) {
                throw new BufferUnderflowException();
            }
            MemoryUtilities.memPutInt((long)this.writePointer, (int)count);
            MemoryUtilities.memPutInt((long)(this.writePointer + 4L), (int)instanceCount);
            MemoryUtilities.memPutInt((long)(this.writePointer + 8L), (int)first);
            MemoryUtilities.memPutInt((long)(this.writePointer + 12L), (int)baseInstance);
            this.writePointer += (long)this.stride;
        }
    }

    public static class NioChunkDrawCallBatcher
    extends ChunkDrawCallBatcher {
        private int writeOffset;

        public NioChunkDrawCallBatcher(int capacity) {
            super(capacity);
        }

        @Override
        public void begin() {
            super.begin();
            this.writeOffset = 0;
        }

        @Override
        public void addIndirectDrawCall(int first, int count, int baseInstance, int instanceCount) {
            ByteBuffer buf = this.buffer;
            buf.putInt(this.writeOffset, count);
            buf.putInt(this.writeOffset + 4, instanceCount);
            buf.putInt(this.writeOffset + 8, first);
            buf.putInt(this.writeOffset + 12, baseInstance);
            this.writeOffset += this.stride;
            ++this.count;
        }
    }
}

