/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util.mst;

import greymerk.roguelike.util.mst.Edge;
import greymerk.roguelike.util.mst.Graph;
import greymerk.roguelike.util.mst.Point;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class MinimumSpanningTree
extends Graph {
    Set<Edge> mstEdges = new HashSet<Edge>();

    public MinimumSpanningTree(Random rand, int size, int edgeLength) {
        this(rand, size, edgeLength, new Coord(0, 0, 0));
    }

    public MinimumSpanningTree(Random rand, int size, int edgeLength, Coord origin) {
        super(rand, size, edgeLength, origin);
        Collections.sort(this.edges);
        for (Edge e : this.edges) {
            Point start = e.getPoints()[0];
            Point end = e.getPoints()[1];
            if (this.find(start) == this.find(end)) continue;
            this.union(start, end);
            this.mstEdges.add(e);
        }
    }

    private void union(Point a, Point b) {
        Point root2;
        Point root1 = this.find(a);
        if (root1 == (root2 = this.find(b))) {
            return;
        }
        if (root1.getRank() > root2.getRank()) {
            root2.setParent(root1);
        } else {
            root1.setParent(root2);
            if (root1.getRank() == root2.getRank()) {
                root2.incRank();
            }
        }
    }

    private Point find(Point p) {
        if (p.getParent() == p) {
            return p;
        }
        p.setParent(this.find(p.getParent()));
        return p.getParent();
    }

    public void generate(IWorldEditor editor, Random rand, IBlockFactory blocks, Coord pos) {
        for (Edge e : this.mstEdges) {
            Coord start = e.getPoints()[0].getPosition();
            start.add(pos);
            Coord end = e.getPoints()[1].getPosition();
            end.add(pos);
            RectHollow.fill(editor, rand, start, end, blocks);
        }
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> toReturn = new ArrayList<Edge>();
        toReturn.addAll(this.mstEdges);
        return toReturn;
    }
}

