/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.factory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.factory.AbstractFactory;
import de.eydamos.backpack.gui.GuiBackpack;
import de.eydamos.backpack.inventory.AbstractInventoryBackpack;
import de.eydamos.backpack.inventory.container.Boundaries;
import de.eydamos.backpack.inventory.container.ContainerAdvanced;
import de.eydamos.backpack.inventory.slot.SlotBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.guiadvanced.form.Label;
import de.eydamos.guiadvanced.subpart.GuiSlot;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.inventory.Slot;

public class FactoryBackpackNormal
extends AbstractFactory<BackpackSave> {
    @Override
    public ContainerAdvanced getContainer(BackpackSave backpack, IInventory[] inventories, EntityPlayer player) {
        int row;
        ContainerAdvanced container = inventories[1] instanceof AbstractInventoryBackpack || inventories[1] instanceof InventoryEnderChest ? new ContainerAdvanced(inventories, backpack) : new ContainerAdvanced();
        int slotsPerRow = backpack.getSlotsPerRow();
        int totalSlots = inventories[1].func_70302_i_();
        int rows = (totalSlots + slotsPerRow - 1) / slotsPerRow;
        int maxWidth = slotsPerRow * 18;
        int x = 8;
        int y = 17;
        container.setWidth(maxWidth + 16);
        container.addBoundary(Boundaries.BACKPACK);
        for (row = 0; row < rows; ++row) {
            int cols = Math.min(slotsPerRow, totalSlots - row * slotsPerRow);
            for (int col = 0; col < cols; ++col) {
                int index = row * slotsPerRow + col;
                container.addSlot(new SlotBackpack(inventories[1], index, x + col * 18, y));
            }
            y += 18;
        }
        container.addBoundary(Boundaries.BACKPACK_END);
        container.addBoundary(Boundaries.INVENTORY);
        y += 14;
        x = (container.getWidth() - 162) / 2;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                container.addSlot(new Slot(inventories[0], index, x + col * 18, y));
            }
            y += 18;
        }
        container.addBoundary(Boundaries.INVENTORY_END);
        container.addBoundary(Boundaries.HOTBAR);
        y += 6;
        for (int col = 0; col < 9; ++col) {
            container.addSlot(new Slot(inventories[0], col, x + col * 18, y));
        }
        container.addBoundary(Boundaries.HOTBAR_END);
        container.setHeight(y + 18 + 7);
        return container;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiContainer(BackpackSave backpack, IInventory[] inventories, EntityPlayer entityPlayer) {
        ContainerAdvanced container = this.getContainer(backpack, inventories, entityPlayer);
        GuiBackpack guiBackpack = new GuiBackpack(container);
        int slotsPerRow = backpack.getSlotsPerRow();
        int inventoryRows = (int)Math.ceil((float)inventories[1].func_70302_i_() / (float)slotsPerRow);
        int textPositionY = 17 + inventoryRows * 18 + 2;
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            Slot slot = (Slot)container.field_75151_b.get(i);
            GuiSlot guiSlot = new GuiSlot(slot.field_75223_e - 1, slot.field_75221_f - 1);
            guiBackpack.addSubPart(guiSlot);
        }
        int inventorySpaceBefore = (int)Math.round((double)container.getWidth() / 2.0 - 81.0);
        guiBackpack.addSubPart(new Label(8, 6, 0x404040, inventories[1].func_145825_b()));
        guiBackpack.addSubPart(new Label(inventorySpaceBefore, textPositionY, 0x404040, "container.inventory"));
        return guiBackpack;
    }
}

