/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.common.Constants;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerAdventure
extends Container {
    protected static final int PLAYER_INV_ROWS = 3;
    protected static final int PLAYER_INV_COLUMNS = 9;
    protected static final int PLAYER_HOT_START = 0;
    protected static final int PLAYER_HOT_END = 8;
    protected static final int PLAYER_INV_END = 35;
    protected static final int PLAYER_INV_LENGTH = 36;
    protected final EntityPlayer player;
    protected final IInventoryTanks inventory;
    protected final Constants.Source source;
    private final int[] fluidsAmount;
    private int itemsCount;
    private boolean requestedUpdate;

    protected ContainerAdventure(EntityPlayer player, IInventoryTanks inventory, Constants.Source source) {
        this.player = player;
        this.inventory = inventory;
        this.source = source;
        this.fluidsAmount = new int[this.inventory.getTanksArray().length];
    }

    protected void bindPlayerInventory(InventoryPlayer invPlayer, int startX, int startY) {
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)invPlayer, col, startX + 18 * col, 58 + startY));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)invPlayer, 9 + row * 9 + col, startX + 18 * col, startY + row * 18));
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.source == Constants.Source.HOLDING) {
            ItemStack parentItem = this.inventory.getParentItem();
            if (parentItem != null && this.player.func_71045_bC() != parentItem) {
                this.player.func_71053_j();
                return;
            }
            if (this.requestedUpdate && this.player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.player).func_71110_a((Container)this, this.func_75138_a());
                this.requestedUpdate = false;
            }
            if (this.detectItemChanges() | this.detectFluidChanges()) {
                this.requestedUpdate = true;
            }
        }
    }

    protected boolean detectItemChanges() {
        ItemStack[] inv = this.inventory.getInventory();
        int tempCount = 0;
        for (int i = 0; i < inv.length - this.inventory.getSlotsOnClosing().length; ++i) {
            if (inv[i] == null) continue;
            ++tempCount;
        }
        if (this.itemsCount != tempCount) {
            this.itemsCount = tempCount;
            return true;
        }
        return false;
    }

    private boolean detectFluidChanges() {
        boolean changesDetected = false;
        for (int i = 0; i < this.fluidsAmount.length; ++i) {
            int amount = this.inventory.getTanksArray()[i].getFluidAmount();
            if (this.fluidsAmount[i] == amount) continue;
            this.fluidsAmount[i] = amount;
            changesDetected = true;
        }
        return changesDetected;
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer player, int fromSlot) {
        Slot slot = this.func_75139_a(fromSlot);
        if (slot == null || slot.func_75211_c() == null) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack result = stack.func_77946_l();
        if (fromSlot < 36 ? !this.transferStackToPack(stack) : !this.mergePlayerInv(stack)) {
            return null;
        }
        if (stack.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (stack.field_77994_a == result.field_77994_a) {
            return null;
        }
        slot.func_82870_a(player, stack);
        return result;
    }

    protected boolean mergePlayerInv(ItemStack stack) {
        return this.func_75135_a(stack, 0, 36, false);
    }

    protected abstract boolean transferStackToPack(ItemStack var1);

    @Nullable
    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        if (this.source == Constants.Source.HOLDING && slot >= 0) {
            if (this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75211_c() == player.func_70694_bm()) {
                return null;
            }
            if (flag == 2 && this.func_75139_a(button).func_75211_c() == player.func_70694_bm()) {
                return null;
            }
        }
        return super.func_75144_a(slot, button, flag, player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    protected boolean func_75135_a(ItemStack initStack, int minIndex, int maxIndex, boolean backward) {
        ItemStack activeStack;
        Slot activeSlot;
        int activeIndex;
        boolean changesMade = false;
        int n = activeIndex = backward ? maxIndex - 1 : minIndex;
        if (initStack.func_77985_e()) {
            while (initStack.field_77994_a > 0 && (!backward && activeIndex < maxIndex || backward && activeIndex >= minIndex)) {
                activeSlot = (Slot)this.field_75151_b.get(activeIndex);
                activeStack = activeSlot.func_75211_c();
                if (activeStack != null && activeStack.func_77973_b() == initStack.func_77973_b() && (!initStack.func_77981_g() || initStack.func_77960_j() == activeStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)initStack, (ItemStack)activeStack)) {
                    int mergedSize = activeStack.field_77994_a + initStack.field_77994_a;
                    int maxStackSize = Math.min(initStack.func_77976_d(), activeSlot.func_75219_a());
                    if (mergedSize <= maxStackSize) {
                        initStack.field_77994_a = 0;
                        activeStack.field_77994_a = mergedSize;
                        activeSlot.func_75218_e();
                        changesMade = true;
                    } else if (activeStack.field_77994_a < maxStackSize && !(activeSlot instanceof SlotFluid)) {
                        initStack.field_77994_a -= maxStackSize - activeStack.field_77994_a;
                        activeStack.field_77994_a = maxStackSize;
                        activeSlot.func_75218_e();
                        changesMade = true;
                    }
                }
                activeIndex += backward ? -1 : 1;
            }
        }
        if (initStack.field_77994_a > 0) {
            int n2 = activeIndex = backward ? maxIndex - 1 : minIndex;
            while (!backward && activeIndex < maxIndex || backward && activeIndex >= minIndex) {
                activeSlot = (Slot)this.field_75151_b.get(activeIndex);
                activeStack = activeSlot.func_75211_c();
                if (activeStack == null) {
                    ItemStack copyStack = initStack.func_77946_l();
                    int mergedSize = copyStack.field_77994_a = Math.min(copyStack.field_77994_a, activeSlot.func_75219_a());
                    activeSlot.func_75215_d(copyStack);
                    initStack.field_77994_a = mergedSize >= initStack.field_77994_a ? 0 : (initStack.field_77994_a -= mergedSize);
                    changesMade = true;
                    break;
                }
                activeIndex += backward ? -1 : 1;
            }
        }
        return changesMade;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.source == Constants.Source.WEARING) {
            this.field_75149_d.remove(player);
        }
        if (!player.field_70170_p.field_72995_K) {
            this.dropContentOnClose();
        }
    }

    protected void dropContentOnClose() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70304_b(i);
            if (itemstack == null) continue;
            this.inventory.func_70299_a(i, null);
            this.player.func_71019_a(itemstack, false);
        }
    }
}

