/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.enumerable;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.common.util.ForgeDirection;

public enum Direction {
    DOWN(ForgeDirection.DOWN),
    UP(ForgeDirection.UP),
    NORTH(ForgeDirection.NORTH),
    SOUTH(ForgeDirection.SOUTH),
    WEST(ForgeDirection.WEST),
    EAST(ForgeDirection.EAST);

    private final ForgeDirection forgeDirection;
    private final Vec3Impl axisVector;
    public static final Direction[] VALUES;
    private static final Map<Vec3Impl, Direction> reverseMap;

    private Direction(ForgeDirection forgeDirection) {
        this.forgeDirection = forgeDirection;
        this.axisVector = Vec3Impl.getFromPool(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
    }

    public ForgeDirection getForgeDirection() {
        return this.forgeDirection;
    }

    public Vec3Impl getAxisVector() {
        return this.axisVector;
    }

    public static Vec3Impl getAxisVector(ForgeDirection forgeDirection) {
        return Direction.VALUES[forgeDirection.ordinal()].axisVector;
    }

    public static Direction getByAxisVector(Vec3Impl vec3) {
        return reverseMap.get(vec3);
    }

    static {
        VALUES = Direction.values();
        reverseMap = Arrays.stream(VALUES).collect(Collectors.toMap(d -> d.axisVector, Function.identity()));
    }
}

