/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.Direction;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import net.minecraftforge.common.util.ForgeDirection;

public interface IAlignment
extends IAlignmentLimits,
IAlignmentProvider {
    public static final int DIRECTIONS_COUNT = Direction.VALUES.length;
    public static final int ROTATIONS_COUNT = Rotation.VALUES.length;
    public static final int FLIPS_COUNT = Flip.VALUES.length;
    public static final int STATES_COUNT = ExtendedFacing.STATES_COUNT;

    public ExtendedFacing getExtendedFacing();

    public void setExtendedFacing(ExtendedFacing var1);

    public IAlignmentLimits getAlignmentLimits();

    @Override
    default public IAlignment getAlignment() {
        return this;
    }

    public static int getAlignmentIndex(ForgeDirection direction, Rotation rotation, Flip flip) {
        return (direction.ordinal() * ROTATIONS_COUNT + rotation.getIndex()) * FLIPS_COUNT + flip.getIndex();
    }

    default public ForgeDirection getDirection() {
        return this.getExtendedFacing().getDirection();
    }

    default public void setDirection(ForgeDirection direction) {
        this.setExtendedFacing(this.getExtendedFacing().with(direction));
    }

    default public Rotation getRotation() {
        return this.getExtendedFacing().getRotation();
    }

    default public void setRotation(Rotation rotation) {
        this.setExtendedFacing(this.getExtendedFacing().with(rotation));
    }

    default public Flip getFlip() {
        return this.getExtendedFacing().getFlip();
    }

    default public void setFlip(Flip flip) {
        this.setExtendedFacing(this.getExtendedFacing().with(flip));
    }

    default public boolean toolSetDirection(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            int j = this.getDirection().ordinal() + 1;
            int valuesLength = Direction.VALUES.length;
            for (int i = 0; i < valuesLength; ++i) {
                if (!this.toolSetDirection(Direction.VALUES[(j + i) % valuesLength].getForgeDirection())) continue;
                return true;
            }
        } else {
            for (ExtendedFacing extendedFacing : ExtendedFacing.FOR_FACING.get(direction)) {
                if (!this.checkedSetExtendedFacing(extendedFacing)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean checkedSetDirection(ForgeDirection direction) {
        if (this.isNewDirectionValid(direction)) {
            this.setDirection(direction);
            return true;
        }
        return false;
    }

    default public boolean canSetToDirectionAny(ForgeDirection direction) {
        for (ExtendedFacing extendedFacing : ExtendedFacing.FOR_FACING.get(direction)) {
            if (!this.isNewExtendedFacingValid(extendedFacing)) continue;
            return true;
        }
        return false;
    }

    default public boolean toolSetRotation(Rotation rotation) {
        if (rotation == null) {
            int flips = Flip.VALUES.length;
            int rotations = Rotation.VALUES.length;
            int jj = this.getFlip().ordinal();
            for (int ii = 0; ii < flips; ++ii) {
                int j = this.getRotation().ordinal();
                for (int i = 1; i < rotations; ++i) {
                    if (!this.checkedSetExtendedFacing(ExtendedFacing.of(this.getDirection(), Rotation.VALUES[(j + i) % rotations], Flip.VALUES[(jj + ii) % flips]))) continue;
                    return true;
                }
            }
            return false;
        }
        return this.checkedSetRotation(rotation);
    }

    default public boolean checkedSetRotation(Rotation rotation) {
        if (this.isNewRotationValid(rotation)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    default public boolean toolSetFlip(Flip flip) {
        if (flip == null) {
            int j = this.getFlip().ordinal();
            int valuesLength = Flip.VALUES.length;
            for (int i = 1; i < valuesLength; ++i) {
                if (!this.checkedSetFlip(Flip.VALUES[(j + i) % valuesLength])) continue;
                return true;
            }
            return false;
        }
        return this.checkedSetFlip(flip);
    }

    default public boolean checkedSetFlip(Flip flip) {
        if (this.isNewFlipValid(flip)) {
            this.setFlip(flip);
            return true;
        }
        return false;
    }

    default public boolean toolSetExtendedFacing(ExtendedFacing extendedFacing) {
        if (extendedFacing == null) {
            int j = this.getExtendedFacing().ordinal() + 1;
            int valuesLength = ExtendedFacing.VALUES.length;
            for (int i = 0; i < valuesLength; ++i) {
                if (!this.checkedSetExtendedFacing(ExtendedFacing.VALUES[(j + i) % valuesLength])) continue;
                return true;
            }
            return false;
        }
        return this.checkedSetExtendedFacing(extendedFacing);
    }

    default public boolean checkedSetExtendedFacing(ExtendedFacing alignment) {
        if (this.isNewExtendedFacingValid(alignment)) {
            this.setExtendedFacing(alignment);
            return true;
        }
        return false;
    }

    default public boolean isNewDirectionValid(ForgeDirection direction) {
        return this.isNewExtendedFacingValid(direction, this.getRotation(), this.getFlip());
    }

    default public boolean isNewRotationValid(Rotation rotation) {
        return this.isNewExtendedFacingValid(this.getDirection(), rotation, this.getFlip());
    }

    default public boolean isNewFlipValid(Flip flip) {
        return this.isNewExtendedFacingValid(this.getDirection(), this.getRotation(), flip);
    }

    default public boolean isExtendedFacingValid() {
        return this.isNewExtendedFacingValid(this.getDirection(), this.getRotation(), this.getFlip());
    }

    @Override
    default public boolean isNewExtendedFacingValid(ForgeDirection direction, Rotation rotation, Flip flip) {
        return this.getAlignmentLimits().isNewExtendedFacingValid(direction, rotation, flip);
    }

    @Override
    default public boolean isNewExtendedFacingValid(ExtendedFacing alignment) {
        return this.getAlignmentLimits().isNewExtendedFacingValid(alignment.getDirection(), alignment.getRotation(), alignment.getFlip());
    }

    default public boolean isFlipChangeAllowed() {
        ExtendedFacing facing = this.getExtendedFacing();
        for (Flip flip : Flip.VALUES) {
            if (flip == this.getFlip() || !this.isNewExtendedFacingValid(facing.with(flip))) continue;
            return true;
        }
        return false;
    }

    default public boolean isRotationChangeAllowed() {
        ExtendedFacing facing = this.getExtendedFacing();
        for (Rotation rotation : Rotation.VALUES) {
            if (rotation == this.getRotation() || !this.isNewExtendedFacingValid(facing.with(rotation))) continue;
            return true;
        }
        return false;
    }
}

