/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.api.core.items.TagList;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public final class RailcraftRegistry {
    private RailcraftRegistry() {
    }

    public static ItemStack getItem(String tag, int qty) {
        tag = MiscTools.cleanTag(tag);
        return GameRegistry.findItemStack((String)Railcraft.getModId(), (String)tag, (int)qty);
    }

    public static void register(String tag, ItemStack stack) {
        if (stack == null) {
            throw new RuntimeException("Don't register null items!");
        }
        tag = MiscTools.cleanTag(tag);
        TagList.addTag(tag);
        Item existingItem = GameRegistry.findItem((String)Railcraft.getModId(), (String)tag);
        Block existingBlock = GameRegistry.findBlock((String)Railcraft.getModId(), (String)tag);
        if (existingItem != null || existingBlock != null) {
            throw new RuntimeException("ItemStack registrations must be unique!");
        }
        GameRegistry.registerCustomItemStack((String)tag, (ItemStack)stack);
    }

    public static void register(ItemStack stack) {
        if (stack == null) {
            throw new RuntimeException("Don't register null items!");
        }
        RailcraftRegistry.register(stack.func_77977_a(), stack);
    }

    public static void register(Item item) {
        if (ModuleManager.getStage() != ModuleManager.Stage.PRE_INIT && ModuleManager.getStage() != ModuleManager.Stage.INIT_FIRST) {
            throw new RuntimeException("Items must be initialized in PreInit or InitFirst!");
        }
        RailcraftRegistry._register(item);
    }

    public static void registerInit(Item item) {
        if (ModuleManager.getStage() != ModuleManager.Stage.INIT_SECOND) {
            throw new RuntimeException("This item must be initialized in InitSecond!");
        }
        RailcraftRegistry._register(item);
    }

    private static void _register(Item item) {
        String tag = item.func_77658_a();
        tag = MiscTools.cleanTag(tag);
        TagList.addTag(tag);
        GameRegistry.registerItem((Item)item, (String)tag);
    }

    public static void register(Block block) {
        RailcraftRegistry.register(block, ItemBlock.class);
    }

    public static void register(Block block, Class<? extends ItemBlock> itemclass) {
        if (ModuleManager.getStage() != ModuleManager.Stage.PRE_INIT && ModuleManager.getStage() != ModuleManager.Stage.INIT_FIRST) {
            throw new RuntimeException("Blocks must be initialized in PreInit or InitFirst!");
        }
        String tag = block.func_149739_a();
        tag = MiscTools.cleanTag(tag);
        TagList.addTag(tag);
        GameRegistry.registerBlock((Block)block, itemclass, (String)tag);
    }
}

