/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.Loader;
import ic2.api.recipe.Recipes;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class ModuleIC2
extends RailcraftModule {
    public static Item lapotronUpgrade;

    @Override
    public boolean canModuleLoad() {
        return IC2Plugin.isModInstalled();
    }

    @Override
    public void printLoadError() {
        Game.log(Level.INFO, "Module disabled: {0}, IC2 not detected", this);
    }

    @Override
    public void initFirst() {
        BlockDetector.registerBlock();
        RailcraftBlocks.registerBlockMachineGamma();
        if (RailcraftConfig.isItemEnabled("ic2.upgrade.lapotron")) {
            lapotronUpgrade = new ItemRailcraft().func_77655_b("railcraft.upgrade.lapotron").func_77625_d(9);
            RailcraftRegistry.register(lapotronUpgrade);
            RailcraftRegistry.register("ic2.upgrade.lapotron", new ItemStack(lapotronUpgrade));
        }
        EnumCart.ENERGY_BATBOX.setup();
        EnumCart.ENERGY_MFE.setup();
        if (IC2Plugin.isClassic()) {
            EnumCart.ENERGY_MFSU.setup();
        } else {
            EnumCart.ENERGY_CESU.setup();
        }
    }

    @Override
    public void postInit() {
        ModuleIC2.createRecipes();
    }

    private static void createRecipes() {
        ItemStack stack;
        EnumCart cart;
        ItemStack batbox;
        BlockDetector blockDetector = BlockDetector.getBlock();
        if (blockDetector != null) {
            ItemStack stack2 = EnumDetector.ENERGY.getItem();
            Object tin = RailcraftItem.plate.getRecipeObject(ItemPlate.EnumPlate.TIN);
            if (tin == null) {
                tin = "ingotTin";
            }
            CraftingPlugin.addShapedRecipe(stack2, false, "XXX", "XPX", "XXX", Character.valueOf('X'), tin, Character.valueOf('P'), Blocks.field_150456_au);
        }
        if ((batbox = IC2Plugin.getItem("batBox")) != null) {
            EnumCart cart2 = EnumCart.ENERGY_BATBOX;
            cart2.setContents(batbox);
            ItemStack stack3 = cart2.getCartItem();
            if (stack3 != null) {
                CraftingPlugin.addShapedRecipe(stack3, "E", "M", Character.valueOf('E'), batbox, Character.valueOf('M'), Items.field_151143_au);
                CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), stack3);
            }
        }
        if (!IC2Plugin.isClassic()) {
            ItemStack cesu = IC2Plugin.getItem("cesuUnit");
            if (cesu != null) {
                cart = EnumCart.ENERGY_CESU;
                cart.setContents(cesu);
                stack = cart.getCartItem();
                if (stack != null) {
                    CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), cesu, Character.valueOf('M'), Items.field_151143_au);
                    CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), stack);
                }
            }
        } else {
            ItemStack mfsu = IC2Plugin.getItem("mfsUnit");
            if (mfsu != null) {
                cart = EnumCart.ENERGY_MFSU;
                cart.setContents(mfsu);
                stack = cart.getCartItem();
                if (stack != null) {
                    CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), mfsu, Character.valueOf('M'), Items.field_151143_au);
                    CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), stack);
                }
            }
        }
        ItemStack mfe = IC2Plugin.getItem("mfeUnit");
        if (mfe != null) {
            cart = EnumCart.ENERGY_MFE;
            cart.setContents(mfe);
            stack = cart.getCartItem();
            if (stack != null) {
                CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), mfe, Character.valueOf('M'), Items.field_151143_au);
                CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), stack);
            }
        }
        if (Loader.isModLoaded((String)"dreamcraft")) {
            return;
        }
        ItemStack battery = IC2Plugin.getItem("reBattery");
        ItemStack machine = IC2Plugin.getItem("machine");
        ItemStack detector = blockDetector != null ? EnumDetector.ENERGY.getItem() : new ItemStack(Blocks.field_150456_au);
        if (battery != null && machine != null) {
            if (EnumMachineGamma.ENERGY_LOADER.isAvaliable()) {
                Recipes.advRecipes.addRecipe(EnumMachineGamma.ENERGY_LOADER.getItem(), new Object[]{"BLB", "BIB", "BDB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ItemStack((Block)Blocks.field_150438_bZ)});
            }
            if (EnumMachineGamma.ENERGY_UNLOADER.isAvaliable()) {
                Recipes.advRecipes.addRecipe(EnumMachineGamma.ENERGY_UNLOADER.getItem(), new Object[]{"BDB", "BIB", "BLB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ItemStack((Block)Blocks.field_150438_bZ)});
            }
        }
        if (RailcraftConfig.isItemEnabled("ic2.upgrade.lapotron")) {
            ItemStack lapotron = IC2Plugin.getItem("lapotronCrystal");
            ItemStack glassCable = IC2Plugin.getItem("glassFiberCableItem");
            ItemStack circuit = IC2Plugin.getItem("advancedCircuit");
            if (lapotron != null && glassCable != null && circuit != null) {
                lapotron.func_77946_l();
                Recipes.advRecipes.addRecipe(new ItemStack(lapotronUpgrade), new Object[]{"GGG", "wLw", "GCG", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w, 1, 0), Character.valueOf('w'), glassCable, Character.valueOf('C'), circuit, Character.valueOf('L'), lapotron});
            }
        }
    }

    public static ItemStack getLapotronUpgrade() {
        if (lapotronUpgrade == null) {
            return null;
        }
        return new ItemStack(lapotronUpgrade);
    }
}

