/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.IInventoryInvalidateable;
import chylex.hee.tileentity.TileEntityAbstractEnergyInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityAbstractTable
extends TileEntityAbstractEnergyInventory
implements IInventoryInvalidateable {
    protected static final int totalTime = 1000;
    protected short time;
    protected short timeStep;
    protected float storedEnergy;
    protected byte requiredStardust;
    private boolean postLoadInvalidate;

    protected abstract boolean onWorkFinished();

    public int getHoldingStardust() {
        return 0;
    }

    public float getMaxStoredEnergy() {
        return 0.0f;
    }

    @Override
    protected byte getDrainTimer() {
        return 15;
    }

    @Override
    protected float getDrainAmount() {
        return this.time < 1000 ? 0.12f : 0.0f;
    }

    @Override
    public boolean isWorking() {
        return this.requiredStardust > 0 && this.getHoldingStardust() >= this.requiredStardust;
    }

    @Override
    protected void onWork() {
        this.time = (short)(this.time + this.timeStep);
        if (this.time >= 1000) {
            if (this.onWorkFinished()) {
                this.resetTable();
                this.updateComparatorStatus();
                this.func_70296_d();
                this.invalidateInventory();
            } else {
                this.time = (short)1000;
            }
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.postLoadInvalidate) {
            this.postLoadInvalidate = false;
            this.invalidateInventory();
        }
    }

    public boolean isComparatorOn() {
        return this.isWorking();
    }

    protected final void updateComparatorStatus() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        }
    }

    protected final void resetTable() {
        this.requiredStardust = 0;
        this.time = this.timeStep = (short)0;
    }

    public final int getTime() {
        return this.time;
    }

    public final int getRequiredStardust() {
        return this.requiredStardust;
    }

    public final float getStoredEnergy() {
        return this.storedEnergy;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setRequiredStardustClient(int requiredStardust) {
        this.requiredStardust = (byte)requiredStardust;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setTimeClient(int time) {
        this.time = (short)time;
    }

    @SideOnly(value=Side.CLIENT)
    public final int getScaledTimeClient(int scale) {
        if (this.time == 0 && this.timeStep == 0) {
            return -1;
        }
        return MathUtil.ceil((double)this.time * (double)scale / 1000.0);
    }

    @SideOnly(value=Side.CLIENT)
    public final void setStoredEnergyClient(float energy) {
        this.storedEnergy = energy;
    }

    @SideOnly(value=Side.CLIENT)
    public final int getScaledStoredEnergyClient(int scale) {
        float maxEnergy = this.getMaxStoredEnergy();
        return MathUtil.floatEquals(maxEnergy, 0.0f) ? -1 : MathUtil.ceil((double)this.storedEnergy * (double)scale / (double)maxEnergy);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (!MathUtil.floatEquals(this.storedEnergy, 0.0f)) {
            nbt.func_74776_a("storedEng", this.storedEnergy);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("storedEng")) {
            this.storedEnergy = nbt.func_74760_g("storedEng");
        }
        this.postLoadInvalidate = true;
    }
}

