/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.util.GTUtility;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GlitchEffectRenderer
extends GeneratedMaterialRenderer {
    public Random rand = new Random();
    int[] red = new int[]{255, 50, 50, 192};
    int[] cyan = new int[]{0, 220, 220, 160};
    final long frameTimeNanos = 10000000L;
    final int loopFrameCount = 200;
    final int glitchedDurationCount = 40;
    final int glitchMoveFrameCount = 5;
    double offsetRed = 0.0;
    double offsetCyan = 0.0;

    private void applyGlitchEffect(IItemRenderer.ItemRenderType type, boolean shouldModulateColor, double offset, int[] color, IIcon ... icons) {
        for (IIcon icon : icons) {
            if (icon == null) continue;
            Tessellator t = Tessellator.field_78398_a;
            if (!type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) continue;
            t.func_78382_b();
            if (shouldModulateColor) {
                t.func_78369_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f);
            } else {
                t.func_78369_a(1.0f, 1.0f, 1.0f, 0.75f);
            }
            t.func_78374_a(0.0 + offset, 0.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            t.func_78374_a(0.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 0.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            t.func_78381_a();
        }
    }

    @Override
    protected void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack item, IIcon icon, boolean shouldModulateColor, int pass, Object ... data) {
        IIcon fluidIcon;
        boolean timing;
        short metaData = (short)item.func_77960_j();
        Item item2 = item.func_77973_b();
        if (!(item2 instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer itemRenderer = (IGT_ItemWithMaterialRenderer)item2;
        int currentFrame = (int)(System.nanoTime() % 2000000000L / 10000000L);
        boolean bl = timing = currentFrame <= 40;
        if (timing && currentFrame % 5 == 0) {
            this.offsetRed = this.rand.nextDouble() * 1.7 * Math.signum(this.rand.nextGaussian());
            this.offsetCyan = this.rand.nextDouble() * 1.7 * Math.signum(this.rand.nextGaussian());
        }
        IIcon itemIcon = itemRenderer.getIcon(metaData, pass);
        IIcon overlay = itemRenderer.getOverlayIcon(metaData, pass);
        FluidStack aFluid = GTUtility.getFluidForFilledItem(item, true);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        if (shouldModulateColor) {
            short[] modulation = itemRenderer.getRGBa(item);
            GL11.glColor4f((float)((float)modulation[0] / 255.0f), (float)((float)modulation[1] / 255.0f), (float)((float)modulation[2] / 255.0f), (float)((float)modulation[3] / 255.0f));
        }
        if (itemIcon != null) {
            this.markNeedsAnimationUpdate(itemIcon);
            this.renderRegularItem(type, item, itemIcon, aFluid == null);
        }
        if (overlay != null && aFluid != null && aFluid.getFluid() != null && (fluidIcon = aFluid.getFluid().getIcon(aFluid)) != null) {
            this.markNeedsAnimationUpdate(fluidIcon);
            this.renderContainedFluid(type, aFluid, fluidIcon);
        }
        if (overlay != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            TextureUtils.bindAtlas((int)itemRenderer.getSpriteNumber());
            this.markNeedsAnimationUpdate(overlay);
            this.renderItemOverlay(type, overlay);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY && timing) {
            GL11.glDisable((int)2929);
            this.applyGlitchEffect(type, shouldModulateColor, this.offsetCyan, this.cyan, itemIcon, overlay);
            GL11.glEnable((int)2929);
            this.applyGlitchEffect(type, shouldModulateColor, this.offsetRed, this.red, itemIcon, overlay);
        }
        GL11.glDisable((int)3042);
    }
}

