/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRInventoryContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.api.render.RenderOverlay;
import gregtech.api.render.SBRContextHolder;
import gregtech.api.render.TextureFactory;
import gregtech.mixin.interfaces.accessors.TesselatorAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class GTRendererCasing
implements ISimpleBlockRenderingHandler {
    public static final int mRenderID = RenderingRegistry.getNextAvailableRenderId();
    private final ITexture[][] textureArray = new ITexture[6][2];
    private final SBRContextHolder sbrContextHolder = new SBRContextHolder();

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        ISBRInventoryContext ctx = this.sbrContextHolder.getSBRInventoryContext(aBlock, aMeta, aModelID, aRenderer);
        this.setupBlockTexturesOnly(aBlock, aMeta, true);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        ctx.renderNegativeYFacing(this.textureArray[0]);
        ctx.renderPositiveYFacing(this.textureArray[1]);
        ctx.renderNegativeZFacing(this.textureArray[2]);
        ctx.renderPositiveZFacing(this.textureArray[3]);
        ctx.renderNegativeXFacing(this.textureArray[4]);
        ctx.renderPositiveXFacing(this.textureArray[5]);
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    private void setupBlockTexturesOnly(Block aBlock, int aMeta, boolean noCoord) {
        for (ForgeDirection tFace : ForgeDirection.VALID_DIRECTIONS) {
            this.textureArray[i][0] = noCoord ? TextureFactory.builder().setFromBlock(aBlock, aMeta).setFromSide(tFace).noWorldCoord().build() : TextureFactory.of(aBlock, aMeta, tFace);
            this.textureArray[i][1] = null;
        }
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = Minecraft.func_71379_u();
        aRenderer.field_147844_c = false;
        TesselatorAccessor tessAccess = (TesselatorAccessor)Tessellator.field_78398_a;
        ISBRWorldContext ctx = this.sbrContextHolder.getSBRWorldContext(aX, aY, aZ, aBlock, aModelID, aRenderer);
        int tMeta = aWorld.func_72805_g(aX, aY, aZ);
        ITexture[] overlaid = RenderOverlay.get(aWorld, aX, aY, aZ);
        if (overlaid == null) {
            this.setupBlockTexturesOnly(aBlock, tMeta, false);
        } else {
            ForgeDirection[] validDirections = ForgeDirection.VALID_DIRECTIONS;
            int validDirectionsLength = validDirections.length;
            for (int i = 0; i < validDirectionsLength; ++i) {
                ForgeDirection tFace = validDirections[i];
                this.textureArray[i][0] = TextureFactory.of(aBlock, tMeta, tFace);
                this.textureArray[i][1] = overlaid[i];
            }
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        ctx.renderNegativeYFacing(this.textureArray[0]);
        ctx.renderPositiveYFacing(this.textureArray[1]);
        ctx.renderNegativeZFacing(this.textureArray[2]);
        ctx.renderPositiveZFacing(this.textureArray[3]);
        ctx.renderNegativeXFacing(this.textureArray[4]);
        ctx.renderPositiveXFacing(this.textureArray[5]);
        return tessAccess.gt5u$hasVertices();
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return mRenderID;
    }
}

