/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import gregtech.GTMod;

public enum ColorOverrideType {
    FLOWER,
    GRASS,
    LEAVES,
    LIQUID;


    public static ColorOverrideType fromName(String name) {
        ColorOverrideType colorOverrideType;
        switch (name) {
            case "FLOWER": {
                colorOverrideType = FLOWER;
                break;
            }
            case "GRASS": {
                colorOverrideType = GRASS;
                break;
            }
            case "LEAVES": {
                colorOverrideType = LEAVES;
                break;
            }
            case "LIQUID": {
                colorOverrideType = LIQUID;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return colorOverrideType;
    }

    public int getColor(int oColor, int x, int z) {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FLOWER: {
                n = GTMod.clientProxy().mPollutionRenderer.colorFoliage(oColor, x, z);
                break;
            }
            case GRASS: {
                n = GTMod.clientProxy().mPollutionRenderer.colorGrass(oColor, x, z);
                break;
            }
            case LEAVES: {
                n = GTMod.clientProxy().mPollutionRenderer.colorLeaves(oColor, x, z);
                break;
            }
            case LIQUID: {
                n = GTMod.clientProxy().mPollutionRenderer.colorLiquid(oColor, x, z);
            }
        }
        return n;
    }
}

