/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.RedstoneWirelessBaseUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;

public abstract class CoverRedstoneWirelessBase
extends CoverLegacyData {
    public static final int MAX_CHANNEL = 65535;
    private static final int PRIVATE_MASK = -131072;
    public static final int PUBLIC_MASK = 65535;
    public static final int CHECKBOX_MASK = 65536;

    public CoverRedstoneWirelessBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || this.coverSide.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTechAPI.sWirelessRedstone.put(this.coverData, (byte)0);
            this.coverData = this.coverData & 0xFFFF0000 | Integer.valueOf(GTUtility.stackToInt(aPlayer.field_71071_by.func_70448_g())).hashCode() & 0xFFFF;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"gt.interact.desc.freq_format", (Object[])new Object[]{this.coverData}));
            return true;
        }
        return false;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || this.coverSide.offsetX == 0 || (double)aY > 0.375 && (double)aY < 0.625 || (double)aZ <= 0.375 || (double)aZ >= 0.625) {
            int n;
            GregTechAPI.sWirelessRedstone.put(this.coverData, (byte)0);
            float[] tCoords = GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ);
            switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                case 0: {
                    n = -32;
                    break;
                }
                case 1: {
                    n = 32;
                    break;
                }
                case 2: {
                    n = -1024;
                    break;
                }
                case 3: {
                    n = 1024;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            int tAdjustVal = n;
            int tPublicChannel = (this.coverData & 0xFFFF) + tAdjustVal;
            this.coverData = tPublicChannel < 0 ? (this.coverData &= 0xFFFF0000) : (tPublicChannel > 65535 ? this.coverData & 0xFFFF0000 | 0xFFFF : this.coverData & 0xFFFF0000 | tPublicChannel);
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"gt.interact.desc.freq_format", (Object[])new Object[]{this.coverData & 0xFFFF}));
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public String getDescription() {
        return StatCollector.func_74837_a((String)"gt.interact.desc.freq_format", (Object[])new Object[]{this.coverData});
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new RedstoneWirelessBaseUIFactory(buildContext).createWindow();
    }
}

