/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.covers.gui.CoverDoesWorkGui;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.modes.DetectionMode;
import gregtech.common.covers.modes.RedstoneMode;
import gregtech.common.gui.mui1.cover.DoesWorkUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverDoesWork
extends CoverLegacyData {
    public static final int FLAG_INVERTED = 1;
    public static final int FLAG_PROGRESS = 2;
    public static final int FLAG_ENABLED = 4;

    public CoverDoesWork(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public DetectionMode getDetectionMode() {
        if (CoverDoesWork.isFlagSet(this.coverData, 2)) {
            return DetectionMode.MACHINE_IDLE;
        }
        if (CoverDoesWork.isFlagSet(this.coverData, 4)) {
            return DetectionMode.MACHINE_ENABLED;
        }
        return DetectionMode.RECIPE_PROGRESS;
    }

    public void setDetectionMode(DetectionMode mode) {
        int n;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RECIPE_PROGRESS: {
                n = this.coverData & 0xFFFFFFFB & 0xFFFFFFFD;
                break;
            }
            case MACHINE_IDLE: {
                n = this.coverData & 0xFFFFFFFB | 2;
                break;
            }
            case MACHINE_ENABLED: {
                n = this.coverData & 0xFFFFFFFD | 4;
            }
        }
        this.coverData = n;
    }

    public RedstoneMode getRedstoneMode() {
        return CoverDoesWork.isFlagSet(this.coverData, 1) ? RedstoneMode.INVERTED : RedstoneMode.NORMAL;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        int n;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NORMAL: {
                n = this.coverData & 0xFFFFFFFE;
                break;
            }
            case INVERTED: {
                n = this.coverData | 1;
            }
        }
        this.coverData = n;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (coverable instanceof IMachineProgress) {
            int tScale;
            IMachineProgress mProgress = (IMachineProgress)((Object)coverable);
            boolean inverted = CoverDoesWork.isFlagSet(this.coverData, 1);
            int signal = 0;
            signal = CoverDoesWork.isFlagSet(this.coverData, 4) ? (inverted == mProgress.isAllowedToWork() ? 0 : 15) : (CoverDoesWork.isFlagSet(this.coverData, 2) ? (inverted == (mProgress.getMaxProgress() == 0) ? 0 : 15) : ((tScale = mProgress.getMaxProgress() / 15) > 0 && mProgress.hasThingsToDo() ? (inverted ? 15 - mProgress.getProgress() / tScale : mProgress.getProgress() / tScale) : (inverted ? 15 : 0)));
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)signal);
        } else {
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)0);
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 6;
        if (this.coverData < 0) {
            this.coverData = 5;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.normal"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.inverted"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.ready"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.not_ready"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.mach_on"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.mach_off"));
            }
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 5;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverDoesWorkGui(this);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new DoesWorkUIFactory(buildContext).createWindow();
    }

    public static boolean isFlagSet(int coverVariable, int flag) {
        return (coverVariable & flag) == flag;
    }
}

