/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;

public class ExoticEnergyInputHelper {
    private static final List<Class<? extends MTEHatch>> sExoticEnergyHatchType = new ArrayList<Class<? extends MTEHatch>>();

    public static void register(Class<? extends MTEHatch> clazz) {
        if (!MTEHatch.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + MTEHatch.class.getName());
        }
        sExoticEnergyHatchType.add(clazz);
    }

    public static boolean drainEnergy(long aEU, Collection<? extends MTEHatch> hatches) {
        for (MTEHatch mTEHatch : hatches) {
            long tDrain = Math.min(mTEHatch.getBaseMetaTileEntity().getStoredEU(), aEU);
            mTEHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(tDrain, false);
            aEU -= tDrain;
        }
        return aEU <= 0L;
    }

    public static boolean isExoticEnergyInput(IMetaTileEntity aHatch) {
        for (Class<? extends MTEHatch> clazz : sExoticEnergyHatchType) {
            if (!clazz.isInstance(aHatch)) continue;
            return true;
        }
        return false;
    }

    public static long getTotalEuMulti(Collection<? extends MTEHatch> hatches) {
        long rEU = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            rEU += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.maxWorkingAmperesIn();
        }
        return rEU;
    }

    public static long getMaxInputVoltageMulti(Collection<? extends MTEHatch> hatches) {
        long rVoltage = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    public static long getAverageInputVoltageMulti(Collection<? extends MTEHatch> hatches) {
        long rVoltage = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        if (hatches.isEmpty()) {
            return 0L;
        }
        return rVoltage / (long)hatches.size();
    }

    public static long getMaxInputAmpsMulti(Collection<? extends MTEHatch> hatches) {
        long rAmp = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            rAmp += tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rAmp;
    }

    public static long getMaxWorkingInputAmpsMulti(Collection<? extends MTEHatch> hatches) {
        long rAmp = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(hatches)) {
            rAmp += tHatch.maxWorkingAmperesIn();
        }
        return rAmp;
    }

    public static List<Class<? extends MTEHatch>> getAllClasses() {
        return Collections.unmodifiableList(sExoticEnergyHatchType);
    }

    static {
        ExoticEnergyInputHelper.register(MTEHatchEnergyMulti.class);
        ExoticEnergyInputHelper.register(MTEHatchEnergyTunnel.class);
    }
}

