/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.client.TetherLineRenderer;
import gregtech.common.tileentities.machines.basic.MTEMagLevPylon;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.IBlockAccess;

public class GTPacketTether
extends GTPacket {
    private int x;
    private int y;
    private int z;

    public GTPacketTether() {
    }

    public GTPacketTether(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GTPacketTether(MTEMagLevPylon pylon) {
        IGregTechTileEntity mte = pylon.getBaseMetaTileEntity();
        this.x = mte.getXCoord();
        this.y = mte.getYCoord();
        this.z = mte.getZCoord();
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.TETHER.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        return new GTPacketTether(this.x, this.y, this.z);
    }

    @Override
    public void process(IBlockAccess world) {
        if (world != null) {
            TetherLineRenderer.addTetherLineRenderer(this.x, this.y, this.z);
        }
    }
}

