/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tileentity;

import com.arc.bloodarsenal.common.BloodArsenal;
import com.arc.bloodarsenal.common.tileentity.TileLPMaterializer;
import com.arc.bloodarsenal.common.tileentity.TileLifeInfuser;
import com.arc.bloodarsenal.common.tileentity.TilePortableAltar;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum PacketHandler {
    INSTANCE;

    private EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("BloodArsenal", new ChannelHandler[]{new BATileCodec()});

    private PacketHandler() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addClientHandler();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addClientHandler() {
        FMLEmbeddedChannel clientChannel = this.channels.get(Side.CLIENT);
        String tileCodec = clientChannel.findChannelHandlerNameForType(BATileCodec.class);
        clientChannel.pipeline().addAfter(tileCodec, "TilePortableAltarHandler", (ChannelHandler)new TilePortableAltarMessageHandler());
        clientChannel.pipeline().addAfter(tileCodec, "TileLifeInfuserHandler", (ChannelHandler)new TileLifeInfuserMessageHandler());
        clientChannel.pipeline().addAfter(tileCodec, "TileLPMaterializer", (ChannelHandler)new TileLPMaterializerMessageHandler());
    }

    public static Packet getPacket(TilePortableAltar tile) {
        TilePortableAltarMessage msg = new TilePortableAltarMessage();
        msg.index = 0;
        msg.x = tile.field_145851_c;
        msg.y = tile.field_145848_d;
        msg.z = tile.field_145849_e;
        msg.items = tile.buildIntDataList();
        msg.fluids = tile.buildFluidList();
        msg.capacity = tile.getCapacity();
        return PacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TileLifeInfuser tile) {
        TileLifeInfuserMessage msg = new TileLifeInfuserMessage();
        msg.index = 1;
        msg.x = tile.field_145851_c;
        msg.y = tile.field_145848_d;
        msg.z = tile.field_145849_e;
        msg.items = tile.buildIntDataList();
        msg.fluids = tile.buildFluidList();
        msg.capacity = tile.getCapacity();
        return PacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TileLPMaterializer tile) {
        TileLPMaterializerMessage msg = new TileLPMaterializerMessage();
        msg.index = 2;
        msg.x = tile.field_145851_c;
        msg.y = tile.field_145848_d;
        msg.z = tile.field_145849_e;
        msg.items = tile.buildIntDataList();
        msg.fluids = tile.buildFluidList();
        msg.capacity = tile.getCapacity();
        return PacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public void sendTo(Packet message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(Packet message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private class BATileCodec
    extends FMLIndexedMessageToMessageCodec<BAMessage> {
        public BATileCodec() {
            this.addDiscriminator(0, TilePortableAltarMessage.class);
            this.addDiscriminator(1, TileLifeInfuserMessage.class);
            this.addDiscriminator(2, TileLPMaterializerMessage.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, BAMessage msg, ByteBuf target) throws Exception {
            target.writeInt(msg.index);
            switch (msg.index) {
                case 0: {
                    int i;
                    int j;
                    target.writeInt(((TilePortableAltarMessage)msg).x);
                    target.writeInt(((TilePortableAltarMessage)msg).y);
                    target.writeInt(((TilePortableAltarMessage)msg).z);
                    target.writeBoolean(((TilePortableAltarMessage)msg).items != null);
                    if (((TilePortableAltarMessage)msg).items != null) {
                        int[] items = ((TilePortableAltarMessage)msg).items;
                        for (j = 0; j < items.length; ++j) {
                            i = items[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeBoolean(((TilePortableAltarMessage)msg).fluids != null);
                    if (((TilePortableAltarMessage)msg).fluids != null) {
                        int[] fluids = ((TilePortableAltarMessage)msg).fluids;
                        for (j = 0; j < fluids.length; ++j) {
                            i = fluids[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeInt(((TilePortableAltarMessage)msg).capacity);
                    break;
                }
                case 1: {
                    int i;
                    int j;
                    target.writeInt(((TileLifeInfuserMessage)msg).x);
                    target.writeInt(((TileLifeInfuserMessage)msg).y);
                    target.writeInt(((TileLifeInfuserMessage)msg).z);
                    target.writeBoolean(((TileLifeInfuserMessage)msg).items != null);
                    if (((TileLifeInfuserMessage)msg).items != null) {
                        int[] items = ((TileLifeInfuserMessage)msg).items;
                        for (j = 0; j < items.length; ++j) {
                            i = items[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeBoolean(((TileLifeInfuserMessage)msg).fluids != null);
                    if (((TileLifeInfuserMessage)msg).fluids != null) {
                        int[] fluids = ((TileLifeInfuserMessage)msg).fluids;
                        for (j = 0; j < fluids.length; ++j) {
                            i = fluids[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeInt(((TileLifeInfuserMessage)msg).capacity);
                    break;
                }
                case 2: {
                    int i;
                    int j;
                    target.writeInt(((TileLPMaterializerMessage)msg).x);
                    target.writeInt(((TileLPMaterializerMessage)msg).y);
                    target.writeInt(((TileLPMaterializerMessage)msg).z);
                    target.writeBoolean(((TileLPMaterializerMessage)msg).items != null);
                    if (((TileLPMaterializerMessage)msg).items != null) {
                        int[] items = ((TileLPMaterializerMessage)msg).items;
                        for (j = 0; j < items.length; ++j) {
                            i = items[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeBoolean(((TileLPMaterializerMessage)msg).fluids != null);
                    if (((TileLPMaterializerMessage)msg).fluids != null) {
                        int[] fluids = ((TileLPMaterializerMessage)msg).fluids;
                        for (j = 0; j < fluids.length; ++j) {
                            i = fluids[j];
                            target.writeInt(i);
                        }
                    }
                    target.writeInt(((TileLPMaterializerMessage)msg).capacity);
                }
            }
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, BAMessage msg) {
            int index = dat.readInt();
            switch (index) {
                case 0: {
                    ((TilePortableAltarMessage)msg).x = dat.readInt();
                    ((TilePortableAltarMessage)msg).y = dat.readInt();
                    ((TilePortableAltarMessage)msg).z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    ((TilePortableAltarMessage)msg).items = new int[3];
                    if (hasStacks) {
                        ((TilePortableAltarMessage)msg).items = new int[3];
                        for (int i = 0; i < ((TilePortableAltarMessage)msg).items.length; ++i) {
                            ((TilePortableAltarMessage)msg).items[i] = dat.readInt();
                        }
                    }
                    boolean hasFluids = dat.readBoolean();
                    ((TilePortableAltarMessage)msg).fluids = new int[6];
                    if (hasFluids) {
                        for (int i = 0; i < ((TilePortableAltarMessage)msg).fluids.length; ++i) {
                            ((TilePortableAltarMessage)msg).fluids[i] = dat.readInt();
                        }
                    }
                    ((TilePortableAltarMessage)msg).capacity = dat.readInt();
                    break;
                }
                case 1: {
                    ((TileLifeInfuserMessage)msg).x = dat.readInt();
                    ((TileLifeInfuserMessage)msg).y = dat.readInt();
                    ((TileLifeInfuserMessage)msg).z = dat.readInt();
                    boolean hasStacks2 = dat.readBoolean();
                    ((TileLifeInfuserMessage)msg).items = new int[3];
                    if (hasStacks2) {
                        ((TileLifeInfuserMessage)msg).items = new int[3];
                        for (int i = 0; i < ((TileLifeInfuserMessage)msg).items.length; ++i) {
                            ((TileLifeInfuserMessage)msg).items[i] = dat.readInt();
                        }
                    }
                    boolean hasFluids2 = dat.readBoolean();
                    ((TileLifeInfuserMessage)msg).fluids = new int[4];
                    if (hasFluids2) {
                        for (int i = 0; i < ((TileLifeInfuserMessage)msg).fluids.length; ++i) {
                            ((TileLifeInfuserMessage)msg).fluids[i] = dat.readInt();
                        }
                    }
                    ((TileLifeInfuserMessage)msg).capacity = dat.readInt();
                    break;
                }
                case 2: {
                    ((TileLPMaterializerMessage)msg).x = dat.readInt();
                    ((TileLPMaterializerMessage)msg).y = dat.readInt();
                    ((TileLPMaterializerMessage)msg).z = dat.readInt();
                    boolean hasStacks3 = dat.readBoolean();
                    ((TileLPMaterializerMessage)msg).items = new int[3];
                    if (hasStacks3) {
                        ((TileLPMaterializerMessage)msg).items = new int[3];
                        for (int i = 0; i < ((TileLPMaterializerMessage)msg).items.length; ++i) {
                            ((TileLPMaterializerMessage)msg).items[i] = dat.readInt();
                        }
                    }
                    boolean hasFluids3 = dat.readBoolean();
                    ((TileLPMaterializerMessage)msg).fluids = new int[4];
                    if (hasFluids3) {
                        for (int i = 0; i < ((TileLPMaterializerMessage)msg).fluids.length; ++i) {
                            ((TileLPMaterializerMessage)msg).fluids[i] = dat.readInt();
                        }
                    }
                    ((TileLPMaterializerMessage)msg).capacity = dat.readInt();
                }
            }
        }
    }

    private static class TilePortableAltarMessageHandler
    extends SimpleChannelInboundHandler<TilePortableAltarMessage> {
        private TilePortableAltarMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TilePortableAltarMessage msg) throws Exception {
            World world = BloodArsenal.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TilePortableAltar) {
                TilePortableAltar altar = (TilePortableAltar)te;
                altar.handlePacketData(msg.items, msg.fluids, msg.capacity);
            }
        }
    }

    private static class TileLifeInfuserMessageHandler
    extends SimpleChannelInboundHandler<TileLifeInfuserMessage> {
        private TileLifeInfuserMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TileLifeInfuserMessage msg) throws Exception {
            World world = BloodArsenal.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TileLifeInfuser) {
                TileLifeInfuser tile = (TileLifeInfuser)te;
                tile.handlePacketData(msg.items, msg.fluids, msg.capacity);
            }
        }
    }

    private static class TileLPMaterializerMessageHandler
    extends SimpleChannelInboundHandler<TileLPMaterializerMessage> {
        private TileLPMaterializerMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TileLPMaterializerMessage msg) throws Exception {
            World world = BloodArsenal.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TileLPMaterializer) {
                TileLPMaterializer tile = (TileLPMaterializer)te;
                tile.handlePacketData(msg.items, msg.fluids, msg.capacity);
            }
        }
    }

    public static class TilePortableAltarMessage
    extends BAMessage {
        int x;
        int y;
        int z;
        int[] items;
        int[] fluids;
        int capacity;
    }

    public static class TileLifeInfuserMessage
    extends BAMessage {
        int x;
        int y;
        int z;
        int[] items;
        int[] fluids;
        int capacity;
    }

    public static class TileLPMaterializerMessage
    extends BAMessage {
        int x;
        int y;
        int z;
        int[] items;
        int[] fluids;
        int capacity;
    }

    private class ClientToServerCodec
    extends FMLIndexedMessageToMessageCodec<BAMessage> {
        public void encodeInto(ChannelHandlerContext ctx, BAMessage msg, ByteBuf target) throws Exception {
            target.writeInt(msg.index);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, BAMessage msg) {
            System.out.println("Packet is recieved and being decoded");
        }
    }

    public static class BAMessage {
        int index;
    }
}

