/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Mixer")
@ModOnly(value={"gregtech"})
public class Mixer {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluidOutput, IIngredient[] input, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        if (input.length == 0) {
            MineTweakerAPI.logError((String)"Mixer recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Mixer recipe for " + output, new Object[]{input[0], ArrayHelper.itemOrNull(input, 1), ArrayHelper.itemOrNull(input, 2), ArrayHelper.itemOrNull(input, 3), fluidInput, fluidOutput, output, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem()));
                    inputs.removeIf(Objects::isNull);
                    GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).fluidInputs(new FluidStack[]{i.nextFluid()}).fluidOutputs(new FluidStack[]{i.nextFluid()}).itemOutputs(new ItemStack[]{i.nextItem()}).duration(i.nextInt()).eut(i.nextInt()).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input, int durationTicks, int euPerTick) {
        if (input.length == 0) {
            MineTweakerAPI.logError((String)"Mixer recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Mixer recipe for " + output, new Object[]{input[0], ArrayHelper.itemOrNull(input, 1), ArrayHelper.itemOrNull(input, 2), ArrayHelper.itemOrNull(input, 3), output, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem()));
                    inputs.removeIf(Objects::isNull);
                    GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(new ItemStack[]{i.nextItem()}).duration(i.nextInt()).eut(i.nextInt()).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
                }
            });
        }
    }
}

