/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.API;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.IOUtils;

public class PresetsList {
    public static final List<Preset> presets = new ArrayList<Preset>();
    protected static PresetRecipeFilter recipeFilter = new PresetRecipeFilter();
    protected static ItemPanelFilter itemFilter = new ItemPanelFilter();

    public static ItemFilter getItemFilter() {
        return itemFilter.getFilter();
    }

    public static void load() {
        List itemStrings;
        File presetsFile = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/presets.ini");
        if (presetsFile == null || !presetsFile.exists()) {
            return;
        }
        try (FileInputStream reader = new FileInputStream(presetsFile);){
            NEIClientConfig.logger.info("Loading presets from file {}", new Object[]{presetsFile});
            itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load presets from file {}", new Object[]{presetsFile, e});
            return;
        }
        JsonParser parser = new JsonParser();
        Preset preset = new Preset();
        presets.clear();
        for (String itemStr : itemStrings) {
            try {
                if (itemStr.isEmpty()) {
                    itemStr = "; {}";
                }
                if (itemStr.startsWith("; ")) {
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (!preset.items.isEmpty()) {
                        presets.add(preset);
                        preset = new Preset();
                    }
                    if (settings.has("name")) {
                        preset.name = settings.get("name").getAsString();
                    }
                    if (settings.has("enabled")) {
                        preset.enabled = settings.get("enabled").getAsBoolean();
                    }
                    if (!settings.has("mode")) continue;
                    preset.mode = PresetMode.valueOf(settings.get("mode").getAsString());
                    continue;
                }
                preset.items.add(itemStr);
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load presets ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        if (!preset.items.isEmpty()) {
            presets.add(preset);
        }
        PresetsList.updateSubsets();
    }

    public static void savePresets() {
        File presetsFile = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/presets.ini");
        ArrayList<String> strings = new ArrayList<String>();
        for (Preset preset : presets) {
            JsonObject settings = new JsonObject();
            settings.add("name", (JsonElement)new JsonPrimitive(preset.name));
            settings.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(preset.enabled)));
            settings.add("mode", (JsonElement)new JsonPrimitive(preset.mode.toString()));
            strings.add("; " + NBTJson.toJson((JsonElement)settings));
            strings.addAll(preset.items);
        }
        try (FileOutputStream output = new FileOutputStream(presetsFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to save presets list to file {}", new Object[]{presetsFile, e});
        }
        PresetsList.recipeFilter.cache = null;
        PresetsList.itemFilter.cache = null;
        PresetsList.updateSubsets();
        CollapsibleItems.saveStates();
        CollapsibleItems.load();
        LayoutManager.markItemsDirty();
    }

    private static void updateSubsets() {
        SubsetWidget.removeTag("Presets");
        for (Preset preset : presets) {
            if (!preset.enabled || preset.mode != PresetMode.SUBSET) continue;
            SubsetWidget.addTag(new SubsetWidget.SubsetTag("Presets." + preset.name, stack -> preset.items.contains(Preset.getIdentifier(stack))));
        }
    }

    static {
        API.addItemFilter(itemFilter);
        API.addRecipeFilter(recipeFilter);
    }

    protected static class ItemPanelFilter
    implements ItemFilter.ItemFilterProvider,
    ItemFilter {
        public Set<String> cache;

        protected ItemPanelFilter() {
        }

        @Override
        public ItemFilter getFilter() {
            if (this.cache == null) {
                this.cache = presets.stream().filter(p -> p.enabled && (p.mode == PresetMode.HIDE || p.mode == PresetMode.REMOVE)).flatMap(p -> p.items.stream()).collect(Collectors.toSet());
            }
            return this.cache.isEmpty() ? null : this;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return !this.cache.contains(Preset.getIdentifier(stack));
        }
    }

    public static class Preset
    implements ItemFilter {
        public String name = "";
        public boolean enabled = true;
        public PresetMode mode = PresetMode.HIDE;
        public Set<String> items = new HashSet<String>();

        public static String getIdentifier(ItemStack stack) {
            return StackInfo.getItemStackGUID(stack);
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.items.contains(Preset.getIdentifier(item));
        }

        public Preset copy() {
            Preset preset = new Preset();
            preset.name = this.name;
            preset.enabled = this.enabled;
            preset.mode = this.mode;
            preset.items = new HashSet<String>(this.items);
            return preset;
        }
    }

    public static enum PresetMode {
        SUBSET,
        HIDE,
        REMOVE,
        GROUP;

    }

    protected static class PresetRecipeFilter
    implements IRecipeFilter.IRecipeFilterProvider,
    IRecipeFilter {
        public Set<String> cache;

        protected PresetRecipeFilter() {
        }

        @Override
        public IRecipeFilter getRecipeFilter() {
            if (this.cache == null) {
                this.cache = presets.stream().filter(p -> p.enabled && p.mode == PresetMode.REMOVE).flatMap(p -> p.items.stream()).collect(Collectors.toSet());
            }
            return this.cache.isEmpty() ? null : this;
        }

        @Override
        public boolean matches(IRecipeHandler handler, int recipeIndex) {
            if (this.matchPositionedStack(handler.getIngredientStacks(recipeIndex), false)) {
                return false;
            }
            PositionedStack result = handler.getResultStack(recipeIndex);
            if (result != null && this.matchPositionedStack(result)) {
                return true;
            }
            List<PositionedStack> others = handler.getOtherStacks(recipeIndex);
            if (!others.isEmpty() && this.matchPositionedStack(others, true)) {
                return true;
            }
            return result == null && others.isEmpty();
        }

        private boolean matchPositionedStack(List<PositionedStack> items, boolean dir) {
            for (PositionedStack pStack : items) {
                if (this.matchPositionedStack(pStack) != dir) continue;
                return true;
            }
            return false;
        }

        private boolean matchPositionedStack(PositionedStack pStack) {
            for (ItemStack stack : pStack.items) {
                if (this.cache.contains(Preset.getIdentifier(stack))) continue;
                return true;
            }
            return false;
        }
    }
}

