/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.helpers.ICustomNameObject;
import appeng.parts.AEBasePart;
import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.IBuildable;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.MMInventory;
import com.recursive_pineapple.matter_manipulator.common.items.MMUpgrades;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import com.recursive_pineapple.matter_manipulator.common.utils.BigFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import com.recursive_pineapple.matter_manipulator.mixin.BlockCaptureDrops;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IRedstoneEmitter;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.joml.Vector3d;

public abstract class AbstractBuildable
extends MMInventory
implements IBuildable {
    private static final double[] SQUARE_ROOTS = new double[1000];
    protected static final double EU_PER_BLOCK = 128.0;
    protected static final double TE_PENALTY = 16.0;
    protected static final double EU_DISTANCE_EXP = 1.25;
    private final HashMap<Pair<SoundResource, World>, SoundInfo> pendingSounds = new HashMap();
    private boolean printedProtectedBlockWarning = false;

    public AbstractBuildable(EntityPlayer player, MMState state, ItemMatterManipulator.ManipulatorTier tier) {
        super(player, state, tier);
    }

    public boolean tryConsumePower(ItemStack stack, World world, int x, int y, int z, ImmutableBlockSpec spec) {
        int hardness = (int)spec.getBlock().func_149712_f(world, x, y, z);
        if (hardness < 0) {
            hardness = 0;
        }
        if (hardness > 999) {
            hardness = 999;
        }
        double euUsage = 128.0 * SQUARE_ROOTS[hardness];
        Block block = spec.getBlock();
        if (block.hasTileEntity(spec.getBlockMeta())) {
            euUsage *= 16.0;
        }
        return this.tryConsumePower(stack, x, y, z, euUsage);
    }

    public boolean tryConsumePower(ItemStack stack, double x, double y, double z, double euUsage) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        euUsage *= Math.pow(this.player.func_70011_f(x, y, z), 1.25);
        if (this.state.hasUpgrade(MMUpgrades.PowerEff)) {
            euUsage *= 0.5;
        }
        return ((ItemMatterManipulator)stack.func_77973_b()).use(stack, euUsage, (EntityLivingBase)this.player);
    }

    public void refillPower(ItemStack stack) {
        ItemMatterManipulator manipulator = (ItemMatterManipulator)stack.func_77973_b();
        assert (manipulator != null);
        manipulator.refillPower(stack, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBlock(World world, int x, int y, int z, ImmutableBlockSpec existing) {
        IFluidBlock fluidBlock;
        boolean voidDrops;
        Block block = existing.getBlock();
        int meta = existing.getBlockMeta();
        boolean bl = voidDrops = !existing.shouldDropItem();
        if (!voidDrops) {
            if (Mods.GregTech.isModLoaded() && GTUtility.isOre((Block)existing.getBlock(), (int)existing.getBlockMeta())) {
                voidDrops = true;
            } else {
                for (int id : OreDictionary.getOreIDs((ItemStack)existing.toStack(1))) {
                    if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
                    voidDrops = true;
                    break;
                }
            }
        }
        if (voidDrops) {
            try {
                BlockCaptureDrops.captureDrops(world);
                block.getDrops(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            finally {
                BlockCaptureDrops.stopCapturingDrops(world);
            }
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        boolean ae = Mods.AppliedEnergistics2.isModLoaded();
        boolean gt = Mods.GregTech.isModLoaded();
        boolean eio = Mods.EnderIO.isModLoaded();
        if (ae && gt) {
            this.emptySuperchest(te);
        }
        if (ae && gt && GlobalMMConfig.BuildingConfig.meEmptying) {
            this.emptyMEOutput(te);
        }
        this.emptyTileInventory(te);
        this.emptyTank(te);
        if (gt) {
            this.removeCovers(te);
        }
        if (ae) {
            this.resetAEMachine(te);
        }
        if (gt) {
            this.resetGTMachine(te);
        }
        if (eio) {
            this.resetConduitBundle(te);
        }
        if (InteropConstants.WIRELESS_CONNECTOR.matches(block, meta)) {
            this.resetTileColour(te);
        }
        if (block instanceof IFluidBlock && (fluidBlock = (IFluidBlock)block).canDrain(world, x, y, z)) {
            this.givePlayerFluids(fluidBlock.drain(world, x, y, z, true));
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150353_l) {
            this.givePlayerFluids(new FluidStack(block == Blocks.field_150355_j ? FluidRegistry.WATER : FluidRegistry.LAVA, 1000));
        } else {
            ArrayList items = block.getDrops(world, x, y, z, meta, 0);
            float chance = ForgeEventFactory.fireBlockHarvesting((ArrayList)items, (World)world, (Block)block, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)this.player);
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                iter.next();
                if (!(world.field_73012_v.nextFloat() > chance)) continue;
                iter.remove();
            }
            this.givePlayerItems(items.toArray(new ItemStack[0]));
        }
        try {
            BlockCaptureDrops.captureDrops(world);
            world.func_147468_f(x, y, z);
        }
        finally {
            this.givePlayerItems(BlockCaptureDrops.stopCapturingDrops(world).toArray(new ItemStack[0]));
        }
    }

    @Optional(value={"gregtech_nh", "appliedenergistics2"})
    protected void emptySuperchest(TileEntity te) {
        IGregTechTileEntity igte;
        Object object;
        if (te instanceof IGregTechTileEntity && (object = (igte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEDigitalChestBase) {
            MTEDigitalChestBase dchest = (MTEDigitalChestBase)object;
            for (IAEItemStack stack : dchest.getStorageList()) {
                stack = dchest.extractItems(stack, Actionable.MODULATE, null);
                while (stack.getStackSize() > 0L) {
                    ItemStack is = stack.getItemStack();
                    stack.decStackSize((long)is.field_77994_a);
                    this.givePlayerItems(is);
                }
            }
        }
    }

    @Optional(value={"gregtech_nh", "appliedenergistics2"})
    protected void emptyMEOutput(TileEntity te) {
        if (te instanceof IGregTechTileEntity) {
            IMetaTileEntity items;
            IGregTechTileEntity igte = (IGregTechTileEntity)te;
            IMetaTileEntity iMetaTileEntity = igte.getMetaTileEntity();
            if (iMetaTileEntity instanceof MTEHatchOutputBusME) {
                MTEHatchOutputBusME bus = (MTEHatchOutputBusME)iMetaTileEntity;
                items = (IItemList)MEOutputCaches.GET_ITEM_STACK_LIST.apply(bus);
                for (IAEItemStack item : items) {
                    if (item.getStackSize() == 0L) continue;
                    this.givePlayerItems(Arrays.asList(BigItemStack.create(item)));
                }
            }
            if ((items = igte.getMetaTileEntity()) instanceof MTEHatchOutputME) {
                MTEHatchOutputME hatch = (MTEHatchOutputME)items;
                IItemList fluids = (IItemList)MEOutputCaches.GET_FLUID_STACK_LIST.apply(hatch);
                for (IAEFluidStack fluid : fluids) {
                    if (fluid.getStackSize() == 0L) continue;
                    this.givePlayerFluids(Arrays.asList(BigFluidStack.create(fluid)));
                }
            }
        }
    }

    protected void emptyTileInventory(TileEntity te) {
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            MMUtils.emptyInventory(this, inv);
        }
    }

    protected void emptyTank(TileEntity te) {
        if (te instanceof IFluidHandler) {
            FluidStack fluid;
            IFluidHandler handler = (IFluidHandler)te;
            if (Mods.GregTech.isModLoaded() && MMUtils.isStockingHatch(handler)) {
                return;
            }
            int i = 0;
            while ((fluid = handler.drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, true)) != null && fluid.getFluid() != null && fluid.amount > 0) {
                this.givePlayerFluids(fluid);
                if (i++ <= 1000) continue;
                break;
            }
        }
    }

    @Optional(value={"gregtech_nh"})
    protected void removeCovers(TileEntity te) {
        if (te instanceof ICoverable) {
            ICoverable coverable = (ICoverable)te;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!coverable.hasCoverAtSide(side)) continue;
                this.givePlayerItems(coverable.detachCover(side));
            }
        }
    }

    @Optional(value={"appliedenergistics2"})
    protected void resetAEMachine(Object machine) {
        block11: {
            ICustomNameObject customName;
            if (machine instanceof ISegmentedInventory) {
                IInventory patterns;
                IInventory cells;
                ISegmentedInventory segmentedInventory = (ISegmentedInventory)machine;
                IInventory upgrades = segmentedInventory.getInventoryByName("upgrades");
                if (upgrades != null) {
                    MMUtils.emptyInventory(this, upgrades);
                }
                if ((cells = segmentedInventory.getInventoryByName("cells")) != null) {
                    MMUtils.emptyInventory(this, cells);
                }
                if ((patterns = segmentedInventory.getInventoryByName("patterns")) != null) {
                    MMUtils.emptyInventory(this, patterns);
                }
            }
            if (machine instanceof ICustomNameObject && (customName = (ICustomNameObject)machine).hasCustomName()) {
                try {
                    customName.setCustomName(null);
                }
                catch (IllegalArgumentException e) {
                    AEBasePart basePart;
                    NBTTagCompound tag;
                    if (!(machine instanceof AEBasePart) || (tag = (basePart = (AEBasePart)machine).getItemStack().func_77978_p()) == null) break block11;
                    tag.func_82580_o("display");
                    if (!tag.func_82582_d()) break block11;
                    basePart.getItemStack().func_77982_d(null);
                }
            }
        }
        if (machine instanceof IPartHost) {
            IPartHost host = (IPartHost)machine;
            for (ForgeDirection dir : ForgeDirection.values()) {
                IFacadePart facadePart;
                IPart part = host.getPart(dir);
                if (part != null) {
                    this.resetAEMachine(part);
                    host.removePart(dir, false);
                    this.givePlayerItems(part.getItemStack(PartItemStack.Break));
                    ArrayList drops = new ArrayList();
                    part.getDrops(drops, false);
                    if (!drops.isEmpty()) {
                        this.givePlayerItems(drops.toArray(new ItemStack[drops.size()]));
                    }
                }
                if ((facadePart = host.getFacadeContainer().getFacade(dir)) == null) continue;
                host.getFacadeContainer().removeFacade(host, dir);
                this.givePlayerItems(facadePart.getItemStack());
            }
        }
    }

    @Optional(value={"gregtech_nh"})
    protected void resetGTMachine(TileEntity te) {
        if (te instanceof IRedstoneEmitter) {
            IRedstoneEmitter emitter = (IRedstoneEmitter)te;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                emitter.setRedstoneOutputStrength(side, false);
            }
        }
        if (te instanceof IColoredTileEntity) {
            IColoredTileEntity colored = (IColoredTileEntity)te;
            colored.setColorization((byte)-1);
        }
    }

    @Optional(value={"EnderIO"})
    protected void resetConduitBundle(TileEntity te) {
        if (te instanceof IConduitBundle) {
            IConduitBundle bundle = (IConduitBundle)te;
            for (IConduit conduit : bundle.getConduits()) {
                this.givePlayerItems(conduit.getDrops().toArray(new ItemStack[0]));
                bundle.removeConduit(conduit);
            }
        }
    }

    @Optional(value={"appliedenergistics2"})
    protected void resetTileColour(TileEntity te) {
        if (te instanceof IColorableTile) {
            IColorableTile colorable = (IColorableTile)te;
            colorable.recolourBlock(ForgeDirection.NORTH, AEColor.Transparent, this.player);
        }
    }

    protected void playSound(World world, int x, int y, int z, SoundResource sound) {
        Pair pair = Pair.of((Object)((Object)sound), (Object)world);
        SoundInfo info = this.pendingSounds.computeIfAbsent((Pair<SoundResource, World>)pair, ignored -> new SoundInfo());
        info.eventCount++;
        info.sumX += x;
        info.sumY += y;
        info.sumZ += z;
    }

    protected void playSounds() {
        this.pendingSounds.forEach((pair, info) -> {
            int avgX = (int)(((SoundInfo)info).sumX / (double)((SoundInfo)info).eventCount);
            int avgY = (int)(((SoundInfo)info).sumY / (double)((SoundInfo)info).eventCount);
            int avgZ = (int)(((SoundInfo)info).sumZ / (double)((SoundInfo)info).eventCount);
            float distance = (float)new Vector3d(this.player.field_70165_t - (double)avgX, this.player.field_70163_u - (double)avgY, this.player.field_70161_v - (double)avgZ).length();
            ((SoundResource)((Object)((Object)pair.left()))).sendPlayToAll(new Location((World)pair.right(), avgX, avgY, avgZ), distance / 16.0f + 1.0f, -1.0f);
        });
        this.pendingSounds.clear();
    }

    protected boolean isEditable(World world, int x, int y, int z) {
        if (!world.func_72962_a(this.player, x, y, z) || MinecraftServer.func_71276_C().func_96290_a(world, x, y, z, this.player)) {
            if (!this.printedProtectedBlockWarning) {
                MMUtils.sendWarningToPlayer(this.player, StatCollector.func_74838_a((String)"mm.info.warning.protected_area"));
                this.printedProtectedBlockWarning = true;
            }
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < SQUARE_ROOTS.length; ++i) {
            AbstractBuildable.SQUARE_ROOTS[i] = 1.0 + Math.sqrt(i);
        }
    }

    private static class MEOutputCaches {
        private static final Function<MTEHatchOutputBusME, IItemList<IAEItemStack>> GET_ITEM_STACK_LIST = MMUtils.exposeFieldGetterLambda(MTEHatchOutputBusME.class, "itemCache");
        private static final Function<MTEHatchOutputME, IItemList<IAEFluidStack>> GET_FLUID_STACK_LIST = MMUtils.exposeFieldGetterLambda(MTEHatchOutputME.class, "fluidCache");

        private MEOutputCaches() {
        }
    }

    private static class SoundInfo {
        private int eventCount;
        private double sumX;
        private double sumY;
        private double sumZ;

        private SoundInfo() {
        }
    }
}

