/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client;

import appeng.api.events.GuiScrollEvent;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.implementations.GuiInterface;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.SlotFake;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.INEIGuiAdapter;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.AcceptsFollowingTooltipLineHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.RecipeInfo;
import com.github.vfyjxf.nee.client.gui.widgets.GuiImgButtonEnableCombination;
import com.github.vfyjxf.nee.config.ItemCombination;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEEPatternTerminalHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketSlotStackChange;
import com.github.vfyjxf.nee.network.packet.PacketStackCountChange;
import com.github.vfyjxf.nee.network.packet.PacketValueConfigServer;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.client.gui.GuiLevelMaintainer;
import com.glodblock.github.client.gui.base.FCGuiEncodeTerminal;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class GuiEventHandler
extends INEIGuiAdapter
implements IContainerTooltipHandler {
    public static final GuiEventHandler instance = new GuiEventHandler();
    private final GuiImgButtonEnableCombination buttonCombination = new GuiImgButtonEnableCombination(0, 0, ItemCombination.ENABLED);
    private AcceptsFollowingTooltipLineHandler acceptsFollowingTooltipLineHandler;
    private List<GuiButton> buttonList;

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isGuiPatternTerm(event.gui)) {
            event.buttonList.add(this.buttonCombination);
            this.buttonList = this.getButtonList((GuiContainer)event.gui, event.buttonList);
            this.updateCombinationButtonPosition((GuiContainer)event.gui);
        } else {
            this.buttonList = null;
        }
        if (event.gui instanceof GuiRecipe) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketValueConfigServer("PatternInterface.check"));
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.buttonList != null && this.isGuiPatternTerm(event.gui)) {
            this.updateCombinationButtonPosition((GuiContainer)event.gui);
        }
    }

    private boolean isGuiPatternTerm(GuiScreen guiScreen) {
        if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            if (Loader.isModLoaded((String)"ae2fc") && guiContainer instanceof FCGuiEncodeTerminal) {
                return false;
            }
            return RecipeInfo.getOverlayHandler((GuiContainer)guiContainer, (String)"crafting") instanceof NEEPatternTerminalHandler || RecipeInfo.getOverlayHandler((GuiContainer)guiContainer, (String)"smelting") instanceof NEEPatternTerminalHandler;
        }
        return false;
    }

    private List<GuiButton> getButtonList(GuiContainer guiContainer, List<Object> items) {
        Rectangle buttonsArea = new Rectangle(guiContainer.field_147003_i + 70, guiContainer.field_147009_r + guiContainer.field_147000_g - 165, 38, 68);
        return items.stream().filter(btn -> btn instanceof GuiButton && btn != this.buttonCombination).map(GuiButton.class::cast).filter(btn -> buttonsArea.contains(btn.field_146128_h, btn.field_146129_i)).collect(Collectors.toList());
    }

    private void updateCombinationButtonPosition(GuiContainer guiContainer) {
        Point leftPoint = new Point(Integer.MAX_VALUE, 0);
        Point rightPoint = new Point(0, 0);
        for (GuiButton button : this.buttonList) {
            if (!button.field_146125_m) continue;
            leftPoint.x = Math.min(leftPoint.x, button.field_146128_h);
            rightPoint.x = Math.max(rightPoint.x, button.field_146128_h);
        }
        for (GuiButton button : this.buttonList) {
            if (!button.field_146125_m) continue;
            if (leftPoint.x == button.field_146128_h) {
                leftPoint.y = Math.max(leftPoint.y, button.field_146129_i + button.field_146121_g);
            }
            if (rightPoint.x != button.field_146128_h) continue;
            rightPoint.y = Math.max(rightPoint.y, button.field_146129_i + button.field_146121_g);
        }
        if (rightPoint.y < leftPoint.y) {
            this.buttonCombination.field_146128_h = rightPoint.x;
            this.buttonCombination.field_146129_i = leftPoint.y - this.buttonCombination.field_146121_g;
        } else if (rightPoint.y == leftPoint.y) {
            this.buttonCombination.field_146128_h = leftPoint.x;
            this.buttonCombination.field_146129_i = leftPoint.y + 2;
        } else {
            this.buttonCombination.field_146128_h = leftPoint.x;
            this.buttonCombination.field_146129_i = rightPoint.y - this.buttonCombination.field_146121_g;
        }
        this.buttonCombination.setValue(ItemCombination.valueOf(NEEConfig.itemCombinationMode));
        this.buttonCombination.field_146125_m = guiContainer.field_147002_h instanceof AEBaseContainer && !this.isCraftingMode((AEBaseContainer)guiContainer.field_147002_h);
        this.buttonCombination.field_146124_l = this.buttonCombination.field_146125_m;
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.button == this.buttonCombination) {
            int ordinal = this.buttonCombination.getCurrentValue().ordinal() + (Mouse.getEventButton() == 0 ? 1 : -1);
            if (ordinal >= ItemCombination.values().length) {
                ordinal = 0;
            }
            if (ordinal < 0) {
                ordinal = ItemCombination.values().length - 1;
            }
            this.buttonCombination.setValue(ItemCombination.values()[ordinal]);
            NEEConfig.setItemCombinationMode(ItemCombination.values()[ordinal].name());
        }
    }

    private boolean isCraftingMode(AEBaseContainer container) {
        if (container instanceof ContainerPatternTerm) {
            return ((ContainerPatternTerm)container).isCraftingMode();
        }
        if (Loader.isModLoaded((String)"ae2fc") && container instanceof FCContainerEncodeTerminal) {
            return ((FCContainerEncodeTerminal)container).isCraftingMode();
        }
        return false;
    }

    public boolean handleDragNDrop(GuiContainer gui, int mouseX, int mouseY, ItemStack draggedStack, int button) {
        if (Loader.isModLoaded((String)"NEIAddons") && NEEConfig.useNEIDragFromNEIAddons) {
            return false;
        }
        if (NEEConfig.enableNEIDragDrop && Loader.isModLoaded((String)"ae2fc") && gui instanceof GuiLevelMaintainer) {
            return false;
        }
        if (NEEConfig.enableNEIDragDrop && draggedStack != null && gui instanceof AEBaseGui) {
            Slot currentSlot = gui.func_146975_c(mouseX, mouseY);
            if (currentSlot instanceof SlotFake) {
                int copySize;
                ItemStack slotStack = currentSlot.func_75211_c();
                ItemStack copyStack = draggedStack.func_77946_l();
                boolean sendPacket = false;
                int n = copySize = NEEConfig.useStackSizeFromNEI ? copyStack.field_77994_a : NEEConfig.draggedStackDefaultSize;
                if (button == 0) {
                    copyStack.field_77994_a = NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)slotStack, (ItemStack)copyStack) ? slotStack.field_77994_a + copySize : copySize;
                    sendPacket = true;
                } else if (button == 1) {
                    copyStack.field_77994_a = NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)slotStack, (ItemStack)copyStack) ? slotStack.field_77994_a : (slotStack == null ? 1 : copySize);
                    sendPacket = true;
                }
                if (sendPacket) {
                    NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketSlotStackChange(copyStack, Collections.singletonList(currentSlot.field_75222_d)));
                    if (!NEEConfig.keepGhostitems) {
                        draggedStack.field_77994_a = 0;
                    }
                    return true;
                }
            }
            if (button == 2) {
                draggedStack.field_77994_a = 0;
            }
        }
        return false;
    }

    @SubscribeEvent
    public boolean handleMouseWheelInput(GuiScrollEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Slot currentSlot = this.getFakeSlotAtPosition((GuiContainer)mc.field_71462_r, event.mouseX, event.mouseY);
        if (currentSlot != null) {
            if (NEIClientConfig.isKeyHashDown((String)"nee.ingredient") && GuiUtils.isCraftingSlot(currentSlot)) {
                this.handleRecipeIngredientChange((GuiContainer)event.guiScreen, currentSlot, event.scrollAmount);
                return true;
            }
            if (NEIClientConfig.isKeyHashDown((String)"nee.count")) {
                NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketStackCountChange(currentSlot.field_75222_d, event.scrollAmount));
                return true;
            }
        }
        return false;
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        PositionedStack currentIngredients;
        Slot currentSlot;
        Slot slot = currentSlot = itemstack != null ? this.getFakeSlotAtPosition(gui, mousex, mousey) : null;
        if (currentSlot != null && (currentIngredients = NEEPatternTerminalHandler.ingredients.get("#" + currentSlot.getSlotIndex())) != null && currentIngredients.items.length > 1 && currentIngredients.containsWithNBT(currentSlot.func_75211_c())) {
            if (this.acceptsFollowingTooltipLineHandler == null || this.acceptsFollowingTooltipLineHandler.tooltipGUID != currentIngredients) {
                this.acceptsFollowingTooltipLineHandler = AcceptsFollowingTooltipLineHandler.of((Object)currentIngredients, (List)currentIngredients.getFilteredPermutations(), (ItemStack)currentIngredients.item);
            }
            if (this.acceptsFollowingTooltipLineHandler != null) {
                this.acceptsFollowingTooltipLineHandler.setActiveStack(currentIngredients.item);
                currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.acceptsFollowingTooltipLineHandler));
            }
        }
        return currenttip;
    }

    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        Slot currentSlot = this.getFakeSlotAtPosition(gui, mousex, mousey);
        if (currentSlot != null) {
            if (this.acceptsFollowingTooltipLineHandler != null) {
                hotkeys.put(NEIClientConfig.getKeyName((String)"nee.ingredient", (int)0, (int)-2013265920), I18n.func_135052_a((String)"neenergistics.gui.tooltip.ingredient.permutation", (Object[])new Object[0]));
            }
            hotkeys.put(NEIClientConfig.getKeyName((String)"nee.count", (int)0, (int)-2013265920), I18n.func_135052_a((String)"neenergistics.gui.tooltip.ingredient.count", (Object[])new Object[0]));
        }
        return hotkeys;
    }

    private Slot getFakeSlotAtPosition(GuiContainer gui, int mousex, int mousey) {
        Slot currentSlot;
        if ((gui instanceof GuiInterface || GuiUtils.isPatternTerm((GuiScreen)gui)) && (currentSlot = gui.func_146975_c(mousex, mousey)) instanceof SlotFake && currentSlot.func_75216_d()) {
            return currentSlot;
        }
        return null;
    }

    private void handleRecipeIngredientChange(GuiContainer gui, Slot currentSlot, int dWheel) {
        int currentSlotIndex = currentSlot.getSlotIndex();
        PositionedStack currentIngredients = NEEPatternTerminalHandler.ingredients.get("#" + currentSlotIndex);
        if (currentIngredients != null && currentIngredients.items.length > 1) {
            ArrayList<Integer> craftingSlots = new ArrayList<Integer>();
            List items = currentIngredients.getFilteredPermutations();
            int currentStackIndex = ItemUtils.getPermutationIndex(currentSlot.func_75211_c(), items);
            ItemStack nextStack = (ItemStack)items.get((items.size() - dWheel + currentStackIndex) % items.size());
            ItemStack currentStack = currentIngredients.item;
            if (NEEConfig.allowSynchronousSwitchIngredient) {
                for (Slot slot : GuiEventHandler.getCraftingSlots(gui)) {
                    PositionedStack slotIngredients = NEEPatternTerminalHandler.ingredients.get("#" + slot.getSlotIndex());
                    if (slotIngredients == null || !slotIngredients.containsWithNBT(nextStack) || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)slotIngredients.item, (ItemStack)currentStack)) continue;
                    slotIngredients.setPermutationToRender(nextStack);
                    craftingSlots.add(slot.field_75222_d);
                }
            } else {
                currentIngredients.setPermutationToRender(nextStack);
                craftingSlots.add(currentSlot.field_75222_d);
            }
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketSlotStackChange(nextStack, craftingSlots));
        }
    }

    private static List<Slot> getCraftingSlots(GuiContainer gui) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (!GuiUtils.isCraftingSlot(slot)) continue;
            craftingSlots.add(slot);
        }
        return craftingSlots;
    }
}

