/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SatPipeNext;
import logisticspipes.network.packets.satpipe.SatPipePrev;
import logisticspipes.network.packets.satpipe.SatPipeSetID;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsSatelliteLogistics
extends CoreRoutedPipe
implements IRequestItems,
IRequireReliableTransport,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public final LinkedList<ItemIdentifierStack> itemList = new LinkedList();
    public final LinkedList<ItemIdentifierStack> oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);
    public static Set<PipeItemsSatelliteLogistics> AllSatellites = Collections.newSetFromMap(new WeakHashMap());
    protected final LinkedList<ItemIdentifierStack> _lostItems = new LinkedList();
    public int satelliteId;

    public PipeItemsSatelliteLogistics(Item item) {
        super(item);
        this.throttleTime = 40;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_SATELLITE_TEXTURE;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.isNthTick(20) && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    private IInventory getRawInventory(ForgeDirection ori) {
        LPPosition pos = new LPPosition(this.getX(), this.getY(), this.getZ());
        pos.moveForward(ori);
        TileEntity tile = pos.getTileEntity(this.getWorld());
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            return null;
        }
        if (!(tile instanceof IInventory)) {
            return null;
        }
        return InventoryHelper.getInventory((IInventory)tile);
    }

    private IInventory getInventory(ForgeDirection ori) {
        IInventory rawInventory = this.getRawInventory(ori);
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryMinecraftAdapter((ISidedInventory)rawInventory, ori.getOpposite(), false);
        }
        return rawInventory;
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (ForgeDirection ori : ForgeDirection.VALID_DIRECTIONS) {
            IInventory inv;
            if (!this.container.isPipeConnected(ori) || (inv = this.getInventory(ori)) == null) continue;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                this.addToList(ItemIdentifierStack.getFromStack(inv.func_70301_a(i)));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChestContent.class).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    public static void cleanup() {
        AllSatellites.clear();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.ensureAllSatelliteStatus();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        super.writeToNBT(nbttagcompound);
    }

    protected int findId(int increment) {
        if (MainProxy.isClient(this.getWorld())) {
            return this.satelliteId;
        }
        int potentialId = this.satelliteId;
        boolean conflict = true;
        block0: while (conflict) {
            if ((potentialId += increment) < 0) {
                return 0;
            }
            conflict = false;
            for (PipeItemsSatelliteLogistics sat : AllSatellites) {
                if (sat.satelliteId != potentialId) continue;
                conflict = true;
                continue block0;
            }
        }
        return potentialId;
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.satelliteId == 0) {
            AllSatellites.remove(this);
        }
        if (this.satelliteId != 0) {
            AllSatellites.add(this);
        }
    }

    public void setNextId(EntityPlayer player) {
        this.satelliteId = this.findId(1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeNext.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
        }
        this.updateWatchers();
    }

    public void setPrevId(EntityPlayer player) {
        this.satelliteId = this.findId(-1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipePrev.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
        }
        this.updateWatchers();
    }

    private void updateWatchers() {
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), ((PipeItemsSatelliteLogistics)this.container.pipe).localModeWatchers);
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        AllSatellites.remove(this);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer(packet, entityplayer);
        entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator iterator = this._lostItems.iterator();
        while (iterator.hasNext()) {
            ItemIdentifierStack stack = (ItemIdentifierStack)iterator.next();
            int received = RequestTree.requestPartial(stack, (CoreRoutedPipe)this.container.pipe, null);
            if (received <= 0) continue;
            if (received == stack.getStackSize()) {
                iterator.remove();
                continue;
            }
            stack.setStackSize(stack.getStackSize() - received);
        }
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._lostItems.add(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    public void setSatelliteId(int integer) {
        this.satelliteId = integer;
    }
}

