/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.bigreactors;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import cpw.mods.fml.relauncher.ReflectionHelper;
import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.client.gui.GuiCyaniteReprocessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerCyaniteReprocessor
extends RecipeHandlerBase {
    private static Map<String, OreDictToReactantMapping> solidToReactant;

    @Override
    public void prepare() {
        solidToReactant = (Map)ReflectionHelper.getPrivateValue(Reactants.class, null, (String[])new String[]{"_solidToReactant"});
        API.setGuiOffset(GuiCyaniteReprocessor.class, (int)8, (int)17);
    }

    public String getRecipeName() {
        return Utils.translate("tile.blockBRDevice.0.name", false);
    }

    @Override
    public String getRecipeID() {
        return "bigreactors.cyaniteReprocessor";
    }

    public String getGuiTexture() {
        return "bigreactors:textures/gui/CyaniteReprocessor.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(68, 25, 27, 18);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCyaniteReprocessor.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)8, (int)16, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)96, (int)18, (int)64);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(68, 24, 0, 177, 27, 18, 100, 0);
        GuiDraw.drawStringC((String)"2000 RF", (int)81, (int)48, (int)0x808080, (boolean)false);
    }

    @Override
    public void loadAllRecipes() {
        for (OreDictToReactantMapping o : solidToReactant.values()) {
            ReactantData data = Reactants.getReactant((String)o.getProduct());
            if (!data.isWaste()) continue;
            for (ItemStack ore : OreDictionary.getOres((String)o.getSource())) {
                this.arecipes.add(new CachedCyaniteReprocessorRecipe(ore, (ItemStack)OreDictionary.getOres((String)"ingotBlutonium").get(0)));
            }
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (Utils.areStacksSameTypeCraftingSafe((ItemStack)OreDictionary.getOres((String)"ingotBlutonium").get(0), result)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (OreDictToReactantMapping o : solidToReactant.values()) {
            ReactantData data = Reactants.getReactant((String)o.getProduct());
            if (!data.isWaste()) continue;
            for (ItemStack ore : OreDictionary.getOres((String)o.getSource())) {
                if (!Utils.areStacksSameTypeCraftingSafe(ore, ingred)) continue;
                this.arecipes.add(new CachedCyaniteReprocessorRecipe(ore, (ItemStack)OreDictionary.getOres((String)"ingotBlutonium").get(0)));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (ingredient.getFluid() == FluidRegistry.WATER) {
            this.loadAllRecipes();
        }
    }

    public class CachedCyaniteReprocessorRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack output;
        public PositionedFluidTank water;

        public CachedCyaniteReprocessorRecipe(ItemStack input, ItemStack output) {
            super(RecipeHandlerCyaniteReprocessor.this);
            input = input.func_77946_l();
            input.field_77994_a = 2;
            this.input = new PositionedStack((Object)input, 36, 25);
            this.output = new PositionedStack((Object)output, 108, 25);
            this.water = new PositionedFluidTank(new FluidStack(FluidRegistry.WATER, 1000), 5000, new Rectangle(1, 1, 16, 62), "neiintegration:textures/overlays.png", new Point(18, 97));
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.water;
        }
    }
}

