/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons.Plants;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import ic2.core.item.ItemCropSeed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.ICropModule;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotCropStick;

public class ModuleIC2Crops
extends ModuleAddon
implements ICropModule {
    private boolean harvestOptimal = true;
    int[] buttonRect = new int[]{8, 34, 20, 20};

    public ModuleIC2Crops(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean isSeedValid(ItemStack seed) {
        return seed.func_77973_b() instanceof ItemCropSeed;
    }

    @Override
    public Block getCropFromSeed(ItemStack seed) {
        TileEntityCrop te = new TileEntityCrop();
        return te.field_145854_h;
    }

    @Override
    public boolean isReadyToHarvest(int x, int y, int z) {
        TileEntity te = this.getCart().field_70170_p.func_147438_o(x, y, z);
        if (te instanceof ICropTile) {
            ICropTile ct = (ICropTile)te;
            if (ct.getCrop() == null) {
                return false;
            }
            if (ct.getCrop() == Crops.weed) {
                return true;
            }
            if (!this.harvestOptimal) {
                return ct.getCrop().canBeHarvested(ct);
            }
            return ct.getSize() >= ct.getCrop().getOptimalHavestSize(ct);
        }
        return false;
    }

    @Override
    public List<ItemStack> harvestCrop(int x, int y, int z, int fortune) {
        TileEntity te = this.getCart().field_70170_p.func_147438_o(x, y, z);
        if (te instanceof ICropTile) {
            ICropTile ct = (ICropTile)te;
            if (ct.getCrop() == Crops.weed) {
                byte size = ct.getSize();
                ct.reset();
                return Collections.singletonList(GameRegistry.makeItemStack((String)"IC2:itemWeed", (int)0, (int)size, (String)""));
            }
            ItemStack[] items = ct.harvest_automated(this.harvestOptimal);
            return items != null ? Arrays.asList(items) : new ArrayList<ItemStack>();
        }
        return null;
    }

    @Override
    public int guiHeight() {
        return 60;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0, (byte)(!this.harvestOptimal ? 1 : 0));
        }
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.harvestOptimal ? 1 : 0));
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.harvestOptimal = data != 0;
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.harvestOptimal = data[0] != 0;
        }
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/checkbox.png");
        this.drawImage(gui, this.buttonRect, 20, 0);
        if (this.harvestOptimal) {
            this.drawImage(gui, this.buttonRect, 40, 0);
        } else {
            this.drawImage(gui, this.buttonRect, 60, 0);
        }
        if (this.inRect(x, y, this.buttonRect)) {
            this.drawImage(gui, this.buttonRect, 0, 0);
        }
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ADDONS.TOGGLE_HARVESTMODE.translate(new String[0]), x, y, this.buttonRect);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getHarvestModeLine(0), 34, 36, 0x404040);
        this.drawString(gui, this.getHarvestModeLine(1), 34, 46, 0x404040);
    }

    private String getHarvestModeLine(int line) {
        return Localization.MODULES.ADDONS.HARVESTMODE.translate(String.valueOf(this.harvestOptimal ? 1 : 0)).split(" ")[line];
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotCropStick(this.getCart(), slotId, 8 + x * 18, 8 + y * 18);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.harvestOptimal = tagCompound.func_74771_c(this.generateNBTName("harvestOptimal", id)) == 1;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74757_a(this.generateNBTName("harvestOptimal", id), this.harvestOptimal);
    }

    @Override
    public void placeCrop(int x, int y, int z, ItemStack seed) {
        CropCard cc = Crops.instance.getCropCard(seed);
        TileEntity te = this.getCart().field_70170_p.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCrop)) {
            return;
        }
        if (!(seed.func_77973_b() instanceof ItemCropSeed)) {
            return;
        }
        ((TileEntityCrop)te).tryPlantIn(cc, 1, (int)ItemCropSeed.getGrowthFromStack((ItemStack)seed), (int)ItemCropSeed.getGainFromStack((ItemStack)seed), (int)ItemCropSeed.getResistanceFromStack((ItemStack)seed), (int)ItemCropSeed.getScannedFromStack((ItemStack)seed));
    }

    @Override
    public boolean isSeedPlaceable(int x, int y, int z, ItemStack seed) {
        int hasCropSticks = -1;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null) continue;
            hasCropSticks = i;
        }
        if (!(seed.func_77973_b() instanceof ItemCropSeed)) {
            return false;
        }
        if (hasCropSticks != -1 && Block.func_149634_a((Item)Ic2Items.crop.func_77973_b()).func_149742_c(this.getCart().field_70170_p, x, y, z) && this.getCart().field_70170_p.func_147437_c(x, y, z)) {
            this.getCart().field_70170_p.func_147449_b(x, y, z, Block.func_149634_a((Item)this.getStack(hasCropSticks).func_77973_b()));
            --this.getStack((int)hasCropSticks).field_77994_a;
            if (this.getStack((int)hasCropSticks).field_77994_a <= 0) {
                this.setStack(hasCropSticks, null);
            }
        }
        CropCard cc = Crops.instance.getCropCard(seed);
        TileEntity te = this.getCart().field_70170_p.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCrop)) {
            return false;
        }
        return cc.canGrow((ICropTile)te) && ((ICropTile)te).getCrop() == null;
    }

    @Override
    public World getWorld() {
        return this.getCart().field_70170_p;
    }
}

