/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.util.I18N;
import binnie.extratrees.genetics.ExtraTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ExtraTreeMutation
implements ITreeMutation {
    protected int chance;
    protected boolean isSecret = false;
    protected IAlleleTreeSpecies allele0;
    protected IAlleleTreeSpecies allele1;
    protected IAllele[] template;
    private final float minTemperature;
    private final float maxTemperature;
    private final float minRainfall;
    private final float maxRainfall;
    private float height = -1.0f;

    public ExtraTreeMutation(IAllele allele0, IAllele allele1, IAllele result, int chance) {
        this(allele0, allele1, Binnie.Genetics.getTreeRoot().getTemplate(result.getUID()), chance);
    }

    public ExtraTreeMutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.minTemperature = 0.0f;
        this.maxTemperature = 2.0f;
        this.minRainfall = 0.0f;
        this.maxRainfall = 2.0f;
        this.allele0 = (IAlleleTreeSpecies)allele0;
        this.allele1 = (IAlleleTreeSpecies)allele1;
        this.template = template;
        this.chance = chance;
        Binnie.Genetics.getTreeRoot().registerMutation((IMutation)this);
    }

    public static void init() {
        IAlleleTreeSpecies lemon = (IAlleleTreeSpecies)ExtraTreeMutation.getVanilla("Lemon");
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAllele)lemon, (IAllele)ExtraTreeSpecies.KeyLime, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.KeyLime, (IAllele)lemon, (IAllele)ExtraTreeSpecies.FingerLime, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAllele)lemon, (IAllele)ExtraTreeSpecies.Pomelo, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Pomelo, ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Manderin, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Pomelo, (IAllele)lemon, (IAllele)ExtraTreeSpecies.Citron, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Manderin, ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Kumquat, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Pomelo, (IAllele)ExtraTreeSpecies.Manderin, (IAllele)ExtraTreeSpecies.Orange, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Citron, (IAllele)ExtraTreeSpecies.Manderin, (IAllele)ExtraTreeSpecies.BuddhaHand, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Kumquat, (IAllele)ExtraTreeSpecies.Manderin, (IAllele)ExtraTreeSpecies.Tangerine, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Kumquat, (IAllele)ExtraTreeSpecies.Manderin, (IAllele)ExtraTreeSpecies.Satsuma, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Pomelo, (IAllele)ExtraTreeSpecies.Orange, (IAllele)ExtraTreeSpecies.Grapefruit, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Pomelo, (IAllele)ExtraTreeSpecies.KeyLime, (IAllele)ExtraTreeSpecies.Lime, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Oak"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.OrchardApple, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.OrchardApple, ExtraTreeMutation.getVanilla("Maple"), (IAllele)ExtraTreeSpecies.SweetCrabapple, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.OrchardApple, (IAllele)ExtraTreeSpecies.SweetCrabapple, (IAllele)ExtraTreeSpecies.FloweringCrabapple, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.OrchardApple, ExtraTreeMutation.getVanilla("Birch"), (IAllele)ExtraTreeSpecies.PrairieCrabapple, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAllele)ExtraTreeSpecies.OrchardApple, (IAllele)ExtraTreeSpecies.Blackthorn, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.CherryPlum, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Chestnut"), (IAllele)ExtraTreeSpecies.Peach, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAllele)ExtraTreeSpecies.Peach, (IAllele)ExtraTreeSpecies.Nectarine, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAllele)ExtraTreeSpecies.Peach, (IAllele)ExtraTreeSpecies.Apricot, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Walnut"), (IAllele)ExtraTreeSpecies.Almond, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Lime"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.WildCherry, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Willow"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.SourCherry, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.BlackCherry, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.Banana, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Banana, ExtraTreeMutation.getVanilla("Kapok"), (IAllele)ExtraTreeSpecies.RedBanana, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Banana, ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Plantain, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Birch"), ExtraTreeMutation.getVanilla("Oak"), (IAllele)ExtraTreeSpecies.Beech, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Birch"), (IAllele)ExtraTreeSpecies.Beech, (IAllele)ExtraTreeSpecies.Alder, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Beech, (IAllele)ExtraTreeSpecies.Aspen, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Aspen, (IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Rowan, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Beech, (IAllele)ExtraTreeSpecies.Aspen, (IAllele)ExtraTreeSpecies.Hazel, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Beech, (IAllele)ExtraTreeSpecies.Rowan, (IAllele)ExtraTreeSpecies.Hawthorn, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Aspen, (IAllele)ExtraTreeSpecies.Elder, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Rowan, (IAllele)ExtraTreeSpecies.Holly, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Willow"), (IAllele)ExtraTreeSpecies.Aspen, (IAllele)ExtraTreeSpecies.Sallow, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Beech, ExtraTreeMutation.getVanilla("Birch"), (IAllele)ExtraTreeSpecies.Pecan, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Beech, ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.CopperBeech, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Lime"), ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.Ash, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Ash, ExtraTreeMutation.getVanilla("Birch"), (IAllele)ExtraTreeSpecies.Whitebeam, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Ash, ExtraTreeMutation.getVanilla("Pine"), (IAllele)ExtraTreeSpecies.Elm, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Ash, ExtraTreeMutation.getVanilla("Larch"), (IAllele)ExtraTreeSpecies.Hornbeam, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Ash, ExtraTreeMutation.getVanilla("Maple"), (IAllele)ExtraTreeSpecies.Sycamore, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Larch"), ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.Yew, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Larch"), (IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.BalsamFir, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), (IAllele)ExtraTreeSpecies.BalsamFir, (IAllele)ExtraTreeSpecies.Fir, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), (IAllele)ExtraTreeSpecies.Fir, (IAllele)ExtraTreeSpecies.Hemlock, 10).setHeight(80);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Fir, ExtraTreeMutation.getVanilla("Larch"), (IAllele)ExtraTreeSpecies.Cedar, 10).setHeight(60);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Fir, ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.DouglasFir, 10).setHeight(60);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.Cypress, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), ExtraTreeMutation.getVanilla("Spruce"), (IAllele)ExtraTreeSpecies.LoblollyPine, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Walnut"), ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Butternut, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Walnut"), ExtraTreeMutation.getVanilla("Oak"), (IAllele)ExtraTreeSpecies.AcornOak, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Olive, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Maple"), ExtraTreeMutation.getVanilla("Lime"), (IAllele)ExtraTreeSpecies.RedMaple, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Maple"), ExtraTreeMutation.getVanilla("Larch"), (IAllele)ExtraTreeSpecies.Sweetgum, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Lime"), (IAllele)ExtraTreeSpecies.Locust, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Iroko, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.OrchardApple, ExtraTreeMutation.getVanilla("Birch"), (IAllele)ExtraTreeSpecies.Pear, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.OldFustic, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.OldFustic, ExtraTreeMutation.getVanilla("Kapok"), (IAllele)ExtraTreeSpecies.OsangeOsange, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Brazilwood, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Brazilwood, ExtraTreeMutation.getVanilla("Kapok"), (IAllele)ExtraTreeSpecies.Purpleheart, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Rosewood, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Rosewood, ExtraTreeMutation.getVanilla("Kapok"), (IAllele)ExtraTreeSpecies.Logwood, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Wenge"), ExtraTreeMutation.getVanilla("Lime"), (IAllele)ExtraTreeSpecies.Gingko, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Beech, ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.Brazilnut, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.RoseGum, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.RoseGum, ExtraTreeMutation.getVanilla("Mahogony"), (IAllele)ExtraTreeSpecies.SwampGum, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Coffee, ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Clove, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.Coffee, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Holly, (IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.Box, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Hemlock, ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.MonkeyPuzzle, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.RoseGum, ExtraTreeMutation.getVanilla("Balsa"), (IAllele)ExtraTreeSpecies.RainbowGum, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.RoseGum, (IAllele)ExtraTreeSpecies.Brazilwood, (IAllele)ExtraTreeSpecies.PinkIvory, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Elder, (IAllele)ExtraTreeSpecies.Raspberry, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAllele)ExtraTreeSpecies.Elder, (IAllele)ExtraTreeSpecies.Redcurrant, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.BlackCherry, (IAllele)ExtraTreeSpecies.Redcurrant, (IAllele)ExtraTreeSpecies.Blackcurrant, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.BlackCherry, (IAllele)ExtraTreeSpecies.Raspberry, (IAllele)ExtraTreeSpecies.Blackberry, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Blackberry, (IAllele)ExtraTreeSpecies.Raspberry, (IAllele)ExtraTreeSpecies.Blueberry, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Blackberry, (IAllele)ExtraTreeSpecies.CherryPlum, (IAllele)ExtraTreeSpecies.Cranberry, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Raspberry, (IAllele)ExtraTreeSpecies.Fir, (IAllele)ExtraTreeSpecies.Juniper, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Raspberry, (IAllele)ExtraTreeSpecies.Lime, (IAllele)ExtraTreeSpecies.Gooseberry, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Raspberry, (IAllele)ExtraTreeSpecies.Orange, (IAllele)ExtraTreeSpecies.GoldenRaspberry, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Rosewood, (IAllele)ExtraTreeSpecies.Cinnamon, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), (IAllele)ExtraTreeSpecies.Brazilnut, (IAllele)ExtraTreeSpecies.Coconut, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), ExtraTreeMutation.getVanilla("Oak"), (IAllele)ExtraTreeSpecies.Cashew, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Wenge"), ExtraTreeMutation.getVanilla("Oak"), (IAllele)ExtraTreeSpecies.Avacado, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Clove, (IAllele)ExtraTreeSpecies.Nutmeg, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAllele)ExtraTreeSpecies.Clove, (IAllele)ExtraTreeSpecies.Allspice, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Allspice, (IAllele)ExtraTreeSpecies.Clove, (IAllele)ExtraTreeSpecies.StarAnise, 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Jungle"), (IAllele)ExtraTreeSpecies.Orange, (IAllele)ExtraTreeSpecies.Mango, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.StarAnise, (IAllele)ExtraTreeSpecies.Mango, (IAllele)ExtraTreeSpecies.Starfruit, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Hazel, (IAllele)ExtraTreeSpecies.Gingko, (IAllele)ExtraTreeSpecies.Candlenut, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Hazel, (IAllele)ExtraTreeSpecies.Gingko, (IAllele)ExtraTreeSpecies.Chilli, 10);
        new ExtraTreeMutation((IAllele)ExtraTreeSpecies.Hazel, (IAllele)ExtraTreeSpecies.Alder, (IAllele)ExtraTreeSpecies.DwarfHazel, 10);
    }

    public static IAllele getVanilla(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele("forestry.tree" + uid);
        if (allele == null) {
            throw new RuntimeException("No forestry species with id " + uid);
        }
        return allele;
    }

    public ExtraTreeMutation setHeight(int minHeight) {
        this.height = minHeight;
        return this;
    }

    public IAlleleTreeSpecies getAllele0() {
        return this.allele0;
    }

    public IAlleleTreeSpecies getAllele1() {
        return this.allele1;
    }

    public float getBaseChance() {
        return this.chance;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public boolean isPartner(IAllele allele) {
        return this.allele0.getUID().equals(allele.getUID()) || this.allele1.getUID().equals(allele.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getUID().equals(allele.getUID())) {
            return this.allele1;
        }
        return this.allele0;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public float getChance(World world, int x, int y, int z, IAlleleTreeSpecies allele0, IAlleleTreeSpecies allele1, ITreeGenome genome0, ITreeGenome genome1) {
        int processedChance = this.chance;
        BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
        if (biome.field_76750_F < this.minTemperature || biome.field_76750_F > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.field_76751_G < this.minRainfall || biome.field_76751_G > this.maxRainfall) {
            return 0.0f;
        }
        if (this.height > 0.0f && (float)y < this.height) {
            return 0.0f;
        }
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }

    public Collection<String> getSpecialConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.height > 0.0f) {
            conditions.add(I18N.localise("extratrees.genetics.requirements.height", Float.valueOf(this.height)));
        }
        return conditions;
    }

    public ITreeRoot getRoot() {
        return Binnie.Genetics.getTreeRoot();
    }
}

