/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFramePopup;
import com.github.weisj.darklaf.components.tabframe.TabFramePopupUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.PanelUI;

public class PanelPopup
extends JPanel
implements TabFramePopup {
    private Component content;
    private boolean open;
    private JTabFrame parent;
    private String title;
    private Icon icon;
    private Alignment alignment;
    private int index;

    public PanelPopup(String title, Component content) {
        this(title, null, content);
    }

    public PanelPopup(String title, Icon icon, Component content) {
        this.setIcon(icon);
        this.setTitle(title);
        this.setContentPane(content);
        this.setEnabled(false);
    }

    @Override
    public String getUIClassID() {
        return "TabFramePanelPopupUI";
    }

    @Override
    public void setUI(PanelUI ui) {
        if (!(ui instanceof TabFramePopupUI)) {
            throw new IllegalArgumentException("Ui needs to be of type " + TabFramePopup.class);
        }
        super.setUI(ui);
    }

    public TabFramePopupUI getPopupUI() {
        return (TabFramePopupUI)((Object)super.getUI());
    }

    @Override
    public Dimension getSize(Dimension rv) {
        if (!this.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getSize();
    }

    @Override
    public int getWidth() {
        if (!this.isEnabled()) {
            return 0;
        }
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        if (!this.isEnabled()) {
            return 0;
        }
        return super.getHeight();
    }

    @Override
    public Component getContentPane() {
        if (this.content == null) {
            this.setContentPane(null);
        }
        return this.content;
    }

    @Override
    public void setContentPane(Component component) {
        Component old = this.content;
        this.content = component;
        if (this.content == null) {
            this.content = new JPanel();
        }
        this.firePropertyChange("content", old, this.content);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateContentUI() {
        if (this.getParent() == null) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void close() {
        if (this.parent != null && this.getAlignment() != null && this.getIndex() >= 0 && this.parent.isSelected(this.getAlignment(), this.getIndex())) {
            this.parent.closeTab(this.getAlignment(), this.getIndex());
        }
    }

    @Override
    public AbstractButton addButton(Icon icon, String tooltipText) {
        return this.getPopupUI().addButton(icon, tooltipText);
    }

    @Override
    public void removeButton(AbstractButton button) {
        this.getPopupUI().removeButton(button);
    }

    @Override
    public void setOpen(boolean open) {
        boolean old = this.open;
        this.open = open;
        this.firePropertyChange("open", old, false);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public JTabFrame getTabFrame() {
        return this.parent;
    }

    @Override
    public void setTabFrame(JTabFrame parent) {
        JTabFrame old = this.parent;
        this.parent = parent;
        this.firePropertyChange("tabFrame", old, parent);
    }

    @Override
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(Alignment alignment) {
        if (alignment == null || this.alignment == Alignment.CENTER) {
            throw new IllegalArgumentException("Illegal alignment: " + (alignment != null ? alignment.toString() : "null"));
        }
        Alignment old = this.alignment;
        this.alignment = alignment;
        this.firePropertyChange("alignment", (Object)old, (Object)alignment);
    }

    @Override
    public void open() {
        if (this.parent != null && this.getAlignment() != null && this.getIndex() >= 0 && !this.parent.isSelected(this.getAlignment(), this.getIndex())) {
            this.parent.openTab(this.getAlignment(), this.getIndex());
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        String old = this.title;
        this.title = title == null ? "" : title;
        this.firePropertyChange("title", old, this.title);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChange("icon", old, icon);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        int old = this.index;
        this.index = index;
        this.firePropertyChange("index", old, index);
    }
}

