/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import gregtech.mixin.interfaces.accessors.EntityPlayerMPAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchObjectHolder;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTEResearchStation
extends TTMultiblockBase
implements ISurvivalConstructable {
    public static final String machine = "EM Machinery";
    public static final String crafter = "EM Crafting";
    private final ArrayList<MTEHatchObjectHolder> eHolders = new ArrayList();
    private GTRecipe.RecipeAssemblyLine tRecipe;
    private static final String assembly = "Assembly line";
    private static final String scanner = "Scanner";
    private String machineType = "Assembly line";
    private ItemStack holdItem;
    private long computationRemaining;
    private long computationRequired;
    private String clientOutputName;
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.hint.1")};
    private String clientLocale = "en_US";
    private static final IStructureDefinition<MTEResearchStation> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"   ", " A ", " A ", "AAA", "AAA", "AAA", "AAA"}, {"AAA", "ACA", "ACA", "ACA", "BCB", "BCB", "BBB"}, {"   ", " C ", "   ", "   ", "ACA", "CCC", "DDD"}, {"   ", " E ", "   ", "   ", "A~A", "CCC", "DDD"}, {"   ", " C ", "   ", "   ", "ACA", "CCC", "DDD"}, {"AAA", "ACA", "ACA", "ACA", "BCB", "BCB", "BBB"}, {"   ", " A ", " A ", "AAA", "AAA", "AAA", "AAA"}})).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3)).addElement('D', GTStructureUtility.buildHatchAdder(MTEResearchStation.class).atLeast(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.InputData).casingIndex(1025).dot(1).buildAndChain(StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1))).addElement('E', HolderHatchElement.INSTANCE.newAny(1027, 2)).build();

    public MTEResearchStation(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEResearchStation(String aName) {
        super(aName);
    }

    private void makeStick() {
        this.mInventory[1].func_77982_d(new NBTTagCompound());
        this.mInventory[1].func_77978_p().func_74778_a("author", EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.WHITE + ' ' + this.machineType + " Recipe Generator");
        AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(this.mInventory[1], this.tRecipe);
    }

    private boolean iterateRecipes() {
        for (GTRecipe ttRecipe : TecTechRecipeMaps.researchStationFakeRecipes.getAllRecipes()) {
            if (!GTUtility.areStacksEqual(ttRecipe.mInputs[0], this.holdItem, true)) continue;
            this.computationRequired = this.computationRemaining = (long)ttRecipe.mDuration * 20L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.eRequiredData = (short)(ttRecipe.mSpecialValue >>> 16);
            this.eAmpereFlow = (short)(ttRecipe.mSpecialValue & 0xFFFF);
            this.mEUt = Math.min(ttRecipe.mEUt, -ttRecipe.mEUt);
            this.eHolders.get(0).getBaseMetaTileEntity().setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEResearchStation(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        for (MTEHatchObjectHolder rack : GTUtility.validMTEList(this.eHolders)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eHolders.clear();
        if (!this.structureCheck_EM("main", 1, 3, 4)) {
            return false;
        }
        for (MTEHatchObjectHolder rack : GTUtility.validMTEList(this.eHolders)) {
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eHolders.size() == 1;
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        block16: {
            block17: {
                ItemStack controllerStack = this.getControllerSlot();
                this.tRecipe = null;
                if (this.eHolders.isEmpty() || this.eHolders.get((int)0).mInventory[0] == null) break block16;
                this.holdItem = this.eHolders.get((int)0).mInventory[0].func_77946_l();
                boolean isDataStick = ItemList.Tool_DataStick.isStackEqual(controllerStack, false, true);
                boolean isDataOrb = ItemList.Tool_DataOrb.isStackEqual(controllerStack, false, true);
                if (!isDataStick && !isDataOrb) break block17;
                switch (this.machineType) {
                    case "Scanner": {
                        if (isDataStick) {
                            for (GTRecipe.RecipeAssemblyLine assRecipe : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
                                if (!GTUtility.areStacksEqual(assRecipe.mResearchItem, this.holdItem, true)) continue;
                                boolean failScanner = true;
                                for (GTRecipe scannerRecipe : RecipeMaps.scannerFakeRecipes.getAllRecipes()) {
                                    if (!GTUtility.areStacksEqual(scannerRecipe.mInputs[0], this.holdItem, true)) continue;
                                    failScanner = false;
                                    break;
                                }
                                if (failScanner) {
                                    return SimpleCheckRecipeResult.ofFailure("wrongRequirements");
                                }
                                this.tRecipe = assRecipe;
                                this.computationRequired = this.computationRemaining = (long)((double)assRecipe.mResearchTime * GTUtility.powInt(2.0, GTUtility.getTier(assRecipe.mResearchVoltage) - 1));
                                this.mMaxProgresstime = 20;
                                this.mEfficiencyIncrease = 10000;
                                this.eRequiredData = 1L;
                                this.eAmpereFlow = 1L;
                                this.mEUt = -Math.max(assRecipe.mResearchVoltage, (int)TierEU.RECIPE_UV);
                                this.eHolders.get(0).getBaseMetaTileEntity().setActive(true);
                                return SimpleCheckRecipeResult.ofSuccess("scanning");
                            }
                        } else {
                            ItemData tData = GTOreDictUnificator.getAssociation(this.holdItem);
                            if (!(tData == null || tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.cell || tData.mMaterial.mMaterial.mElement == null || tData.mMaterial.mMaterial.mElement.mIsIsotope || tData.mMaterial.mMaterial == Materials.Magic || tData.mMaterial.mMaterial.getMass() <= 0L)) {
                                this.tRecipe = new GTRecipe.RecipeAssemblyLine(this.holdItem.func_77946_l(), (int)(tData.mMaterial.mMaterial.getMass() * 8192L), (int)TierEU.RECIPE_UV, GTValues.emptyItemStackArray, GTValues.emptyFluidStackArray, this.holdItem.func_77946_l(), 1, 30);
                                this.computationRequired = this.computationRemaining = (long)GTUtility.safeInt(tData.mMaterial.mMaterial.getMass() * 8192L);
                                this.mMaxProgresstime = 20;
                                this.mEfficiencyIncrease = 10000;
                                this.eRequiredData = 1L;
                                this.eAmpereFlow = 1L;
                                this.mEUt = (int)(-TierEU.RECIPE_UV);
                                this.eHolders.get(0).getBaseMetaTileEntity().setActive(true);
                                return SimpleCheckRecipeResult.ofSuccess("scanning");
                            }
                        }
                        break block16;
                    }
                    case "Assembly line": {
                        for (GTRecipe.RecipeAssemblyLine assRecipe : TecTechRecipeMaps.researchableALRecipeList) {
                            if (!GTUtility.areStacksEqual(assRecipe.mResearchItem, this.holdItem, true)) continue;
                            this.tRecipe = assRecipe;
                            if (!this.iterateRecipes()) continue;
                            return SimpleCheckRecipeResult.ofSuccess("researching");
                        }
                        break;
                    }
                }
                break block16;
            }
            return CheckRecipeResultRegistry.NO_DATA_STICKS;
        }
        this.holdItem = null;
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        for (MTEHatchObjectHolder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        return SimpleCheckRecipeResult.ofFailure("no_research_item");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eHolders.isEmpty() && this.tRecipe != null) {
            this.eHolders.get(0).getBaseMetaTileEntity().setActive(false);
            if (ItemList.Tool_DataStick.isStackEqual(this.mInventory[1], false, true)) {
                this.makeStick();
                this.eHolders.get((int)0).mInventory[0] = null;
            } else if (ItemList.Tool_DataOrb.isStackEqual(this.mInventory[1], false, true)) {
                BehaviourDataOrb.setDataTitle(this.mInventory[1], "Elemental-Scan");
                ItemData tData = GTOreDictUnificator.getAssociation(this.holdItem);
                assert (tData != null);
                BehaviourDataOrb.setDataName(this.mInventory[1], tData.mMaterial.mMaterial.mElement.name());
                this.eHolders.get((int)0).mInventory[0] = null;
            }
        }
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        this.tRecipe = null;
        this.holdItem = null;
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.type")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.3")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.4")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.5")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.research.desc.6")).addTecTechHatchInfo().beginStructureBlock(3, 7, 7, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.holder.tier.09.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.CenterPillar"), 2).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataConnector"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), 1).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), 1).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingBackMain"), 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.eEnergyMulti)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Energy_Hatches", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", (this.mEUt <= 0 ? StatCollector.func_74837_a((String)"tt.keyphrase.Probably_uses", (Object[])new Object[]{this.clientLocale}) + ": " : StatCollector.func_74837_a((String)"tt.keyphrase.Probably_makes", (Object[])new Object[]{this.clientLocale}) + ": ") + EnumChatFormatting.RED + GTUtility.formatNumbers(Math.abs(this.mEUt)) + EnumChatFormatting.RESET + " EU/t " + StatCollector.func_74837_a((String)"tt.keyword.at", (Object[])new Object[]{this.clientLocale}) + " " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.eAmpereFlow) + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyphrase.Tier_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + GTValues.VN[this.getMaxEnergyInputTier_EM()] + EnumChatFormatting.RESET + " / " + EnumChatFormatting.GREEN + GTValues.VN[this.getMinEnergyInputTier_EM()] + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyphrase.Amp_Rating", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.eMaxAmpereFlow) + EnumChatFormatting.RESET + " A", StatCollector.func_74837_a((String)"tt.keyword.Problems", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.Efficiency", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74837_a((String)"tt.keyword.PowerPass", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.ePowerPass + EnumChatFormatting.RESET + " " + StatCollector.func_74837_a((String)"tt.keyword.SafeVoid", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.BLUE + this.eSafeVoid, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Available", (Object[])new Object[]{this.clientLocale}) + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.eAvailableData) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.eRequiredData) + EnumChatFormatting.RESET, StatCollector.func_74837_a((String)"tt.keyphrase.Computation_Remaining", (Object[])new Object[]{this.clientLocale}) + ":", EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.computationRemaining / 20L) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getComputationRequired())};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (MTEHatchObjectHolder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eHolders) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[9]);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("eComputationRemaining", this.computationRemaining);
        aNBT.func_74772_a("eComputationRequired", this.computationRequired);
        aNBT.func_74778_a("eMachineType", this.machineType);
        if (this.holdItem != null) {
            aNBT.func_74782_a("eHold", (NBTBase)this.holdItem.func_77955_b(new NBTTagCompound()));
        } else {
            aNBT.func_82580_o("eHold");
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.computationRemaining = aNBT.func_74763_f("eComputationRemaining");
        this.computationRequired = aNBT.func_74763_f("eComputationRequired");
        this.machineType = aNBT.func_74764_b("eMachineType") ? aNBT.func_74779_i("eMachineType") : assembly;
        this.holdItem = aNBT.func_74764_b("eHold") ? ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("eHold")) : null;
    }

    @Override
    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        for (MTEHatchObjectHolder r : this.eHolders) {
            r.getBaseMetaTileEntity().setActive(false);
        }
        this.computationRemaining = 0L;
        this.computationRequired = 0L;
        this.tRecipe = null;
        this.holdItem = null;
    }

    @Override
    protected boolean supportsSlotAutomation(int aSlot) {
        return aSlot == this.getControllerSlotIndex();
    }

    @Override
    public void onFirstTick_EM(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide() && this.computationRemaining > 0L) {
            this.tRecipe = null;
            if (this.holdItem != null && ItemList.Tool_DataStick.isStackEqual(this.mInventory[1], false, true)) {
                for (GTRecipe.RecipeAssemblyLine tRecipe : TecTechRecipeMaps.researchableALRecipeList) {
                    if (!GTUtility.areStacksEqual(tRecipe.mResearchItem, this.holdItem, true)) continue;
                    this.tRecipe = tRecipe;
                    break;
                }
            }
            if (this.tRecipe == null) {
                this.holdItem = null;
                this.computationRemaining = 0L;
                this.computationRequired = 0L;
                this.mMaxProgresstime = 0;
                this.mEfficiencyIncrease = 0;
                for (MTEHatchObjectHolder r : this.eHolders) {
                    r.getBaseMetaTileEntity().setActive(false);
                }
            }
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.computationRemaining <= 0L) {
            this.computationRemaining = 0L;
            this.mProgresstime = this.mMaxProgresstime;
            return true;
        }
        this.computationRemaining -= this.eAvailableData;
        this.mProgresstime = 1;
        return super.onRunningTick(aStack);
    }

    public final boolean addHolderToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchObjectHolder) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eHolders.add((MTEHatchObjectHolder)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        super.onRightclick(aBaseMetaTileEntity, aPlayer);
        if (!aBaseMetaTileEntity.isClientSide() && aPlayer instanceof EntityPlayerMP) {
            if (aPlayer instanceof EntityPlayerMPAccessor) {
                this.clientLocale = ((EntityPlayerMPAccessor)aPlayer).gt5u$getTranslator();
            }
        } else {
            return true;
        }
        return true;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        switch (this.machineType) {
            case "Scanner": {
                this.machineType = assembly;
                break;
            }
            case "Assembly line": {
                this.machineType = scanner;
            }
        }
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("gt.blockmachines.multimachine.em.research.mode." + this.machineType.replace(" ", "_"), new Object[0]));
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.scannerFakeRecipes, TecTechRecipeMaps.researchStationFakeRecipes);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.researching_item", (Object[])new Object[]{this.clientOutputName})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.computationRequired > 0L && this.clientOutputName != null && !this.clientOutputName.isEmpty()))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.research_progress", (Object[])new Object[]{this.getComputationConsumed(), this.getComputationRequired(), GTUtility.formatNumbers(this.getComputationProgress())})).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.computationRequired > 0L && this.clientOutputName != null && !this.clientOutputName.isEmpty()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.computationRequired, aLong -> {
            this.computationRequired = aLong;
        }))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.computationRemaining, aLong -> {
            this.computationRemaining = aLong;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> {
            if (this.tRecipe != null && this.tRecipe.mOutput != null) {
                return this.tRecipe.mOutput.func_82833_r();
            }
            return "";
        }, aString -> {
            this.clientOutputName = aString;
        }));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        tag.func_74757_a("hasProblems", this.getIdealStatus() - this.getRepairStatus() > 0);
        tag.func_74776_a("efficiency", (float)this.mEfficiency / 100.0f);
        tag.func_74757_a("incompleteStructure", (this.getErrorDisplayID() & 0x40) != 0);
        tag.func_74778_a("machineType", this.machineType);
        tag.func_74772_a("computation", this.getComputationConsumed());
        tag.func_74772_a("computationRequired", this.getComputationRequired());
    }

    private long getComputationConsumed() {
        return (this.computationRequired - this.computationRemaining) / 20L;
    }

    private long getComputationRequired() {
        return this.computationRequired / 20L;
    }

    private double getComputationProgress() {
        return 100.0 * ((double)this.getComputationRequired() > 0.0 ? (double)this.getComputationConsumed() / (double)this.getComputationRequired() : 0.0);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.incomplete") + SpecialChars.RESET);
        }
        String efficiency = SpecialChars.RESET + StatCollector.func_74837_a((String)"GT5U.waila.multiblock.status.efficiency", (Object[])new Object[]{Float.valueOf(tag.func_74760_g("efficiency"))});
        if (tag.func_74767_n("hasProblems")) {
            currentTip.add(SpecialChars.RED + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.has_problem") + efficiency);
        } else if (!tag.func_74767_n("incompleteStructure")) {
            currentTip.add(SpecialChars.GREEN + StatCollector.func_74838_a((String)"GT5U.waila.multiblock.status.running_fine") + efficiency);
        }
        currentTip.add(StatCollector.func_74838_a((String)("gt.blockmachines.multimachine.em.research.mode." + tag.func_74779_i("machineType").replace(" ", "_"))));
        currentTip.add(StatCollector.func_74837_a((String)"gt.blockmachines.multimachine.em.research.computation", (Object[])new Object[]{tag.func_74762_e("computation"), tag.func_74762_e("computationRequired")}));
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 1, 3, 4, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("main", stackSize, 1, 3, 4, elementBudget, source, actor, false, true);
    }

    public IStructureDefinition<MTEResearchStation> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    private static enum HolderHatchElement implements IHatchElement<MTEResearchStation>
    {
        INSTANCE;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchObjectHolder.class);
        }

        @Override
        public IGTHatchAdder<? super MTEResearchStation> adder() {
            return MTEResearchStation::addHolderToMachineList;
        }

        @Override
        public long count(MTEResearchStation t) {
            return t.eHolders.size();
        }
    }
}

