/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei.handlers;

import gregtech.api.enums.Mods;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public final class NeiTextureHandler {
    public static final NeiTextureHandler RECIPE_BUTTON = new NeiTextureHandler(128, 116, 24, 24);
    public final double minU;
    public final double maxU;
    public final double minV;
    public final double maxV;
    public final double width;
    public final double height;
    public static final ResourceLocation TEXTURE = new ResourceLocation(Mods.GTPlusPlus.ID + ":textures/gui/nei/widgets.png");
    public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;
    public static final ResourceLocation ITEM_TEX = TextureMap.field_110576_c;
    public static final ResourceLocation GLINT_TEX = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static int BRIGHTNESS_MAX = 0xF000F0;

    public NeiTextureHandler(int x, int y, int width, int height) {
        this(width, height, (float)(0.00390625 * (double)x), (float)(0.00390625 * (double)(x + width)), (float)(0.00390625 * (double)y), (float)(0.00390625 * (double)(y + height)));
    }

    public NeiTextureHandler(double width, double height, double minU, double maxU, double minV, double maxV) {
        this.width = width;
        this.height = height;
        this.minU = minU;
        this.maxU = maxU;
        this.minV = minV;
        this.maxV = maxV;
    }

    public void renderIcon(double x, double y, double width, double height, double zLevel, boolean doDraw) {
        this.renderIcon(x, y, width, height, zLevel, doDraw, false);
    }

    public void renderIcon(double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (doDraw) {
            NeiTextureHandler.bindTexture(TEXTURE);
            tessellator.func_78382_b();
        }
        if (flipY) {
            tessellator.func_78374_a(x, y + height, zLevel, this.minU, this.minV);
            tessellator.func_78374_a(x + width, y + height, zLevel, this.maxU, this.minV);
            tessellator.func_78374_a(x + width, y + 0.0, zLevel, this.maxU, this.maxV);
            tessellator.func_78374_a(x, y + 0.0, zLevel, this.minU, this.maxV);
        } else {
            tessellator.func_78374_a(x, y + height, zLevel, this.minU, this.maxV);
            tessellator.func_78374_a(x + width, y + height, zLevel, this.maxU, this.maxV);
            tessellator.func_78374_a(x + width, y + 0.0, zLevel, this.maxU, this.minV);
            tessellator.func_78374_a(x, y + 0.0, zLevel, this.minU, this.minV);
        }
        if (doDraw) {
            tessellator.func_78381_a();
        }
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindTexture(String string) {
        NeiTextureHandler.engine().func_110577_a(new ResourceLocation(string));
    }

    public static void bindTexture(ResourceLocation tex) {
        NeiTextureHandler.engine().func_110577_a(tex);
    }
}

