/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.math;

import gregtech.api.enums.GTValues;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.Utils;
import java.text.NumberFormat;
import java.util.Random;

public class MathUtils {
    private static final Random rand = GTPPCore.RANDOM;
    private static final NumberFormat sNumberFormat = NumberFormat.getInstance();

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static long randLong(long min, long max) {
        return MathUtils.nextLong(max - min + 1L) + min;
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = rand.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static double randDouble(double min, double max) {
        return MathUtils.nextDouble(max - min + 1.0) + min;
    }

    private static double nextDouble(double n) {
        double val;
        double bits;
        while ((bits = (double)(rand.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0) < 0.0) {
        }
        return val;
    }

    public static float randFloat(float min, float max) {
        return MathUtils.nextFloat(max - min + 1.0f) + min;
    }

    private static float nextFloat(float n) {
        float val;
        float bits;
        while ((bits = (float)(rand.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0f) < 0.0f) {
        }
        return val;
    }

    public static double findPercentage(double current, double max) {
        return (double)Math.round(current / max * 100.0 * 100.0) / 100.0;
    }

    public static float findPercentage(float current, float max) {
        return (float)((double)Math.round((double)(current / max * 100.0f) * 100.0) / 100.0);
    }

    public static int findPercentageOfInt(long input, float percentage) {
        return (int)((float)input * (percentage / 100.0f));
    }

    public static double decimalRounding(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public static double decimalRoundingToWholes(double d) {
        return 5L * Math.round(d / 5.0);
    }

    public static int roundToClosestInt(double d) {
        return (int)((double)Math.round(d * 2.0) / 2.0);
    }

    public static long roundToClosestLong(double d) {
        return (long)((double)Math.round(d * 2.0) / 2.0);
    }

    public static boolean isNumberEven(long x) {
        return x % 2L == 0L;
    }

    public static float celsiusToKelvin(int i) {
        double f = (float)i + 273.15f;
        return (int)MathUtils.decimalRoundingToWholes(f);
    }

    public static long[] simplifyNumbersToSmallestForm(long[] inputArray) {
        long GCD = MathUtils.gcd(inputArray);
        long[] outputArray = new long[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            outputArray[i] = GCD != 0L ? inputArray[i] / GCD : inputArray[i];
        }
        if (outputArray.length > 0) {
            return outputArray;
        }
        return GTValues.emptyLongArray;
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static long gcd(long[] input) {
        long result = input[0];
        for (int i = 1; i < input.length; ++i) {
            result = MathUtils.gcd(result, input[i]);
        }
        return result;
    }

    public static int getRgbAsHex(short[] RGBA) {
        return Utils.rgbtoHexValue(RGBA[0], RGBA[1], RGBA[2]);
    }

    public static byte safeByte(long number) {
        return (byte)MathUtils.clamp_long(number, -128L, 127L);
    }

    public static int safeInt(long number, int margin) {
        return (int)MathUtils.clamp_long(number, Integer.MIN_VALUE + margin, Integer.MAX_VALUE - margin);
    }

    public static int safeInt(long number) {
        return number > GTValues.V[GTValues.V.length - 1] ? MathUtils.safeInt(GTValues.V[GTValues.V.length - 1], 1) : (number < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)number);
    }

    public static int getRandomFromArray(int[] mValues) {
        int[] mLargeChanceArray = new int[(mValues.length - 1) * 1000];
        for (int g = 0; g < mLargeChanceArray.length; ++g) {
            int mValueSelection = MathUtils.randInt(0, mValues.length - 1);
            mLargeChanceArray[g] = mValues[mValueSelection];
        }
        return mLargeChanceArray[MathUtils.randInt(0, mLargeChanceArray.length - 1)];
    }

    public static int getIntAverage(int[] aDataSet) {
        if (aDataSet.length == 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        int total = 0;
        for (int i : aDataSet) {
            total += i;
        }
        return MathUtils.safeInt(total / divisor);
    }

    public static int howManyPlaces(int aValueForGen) {
        String a = String.valueOf(aValueForGen);
        return a.length();
    }

    public static int safeCast_LongToInt(long l) {
        return (int)MathUtils.clamp_long(l, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static long clamp_long(long number, long min, long max) {
        if (number > max) {
            return max;
        }
        if (number < min) {
            return min;
        }
        return number;
    }

    public static int balance(int aInput, int aMin, int aMax) {
        return Math.max(Math.min(aInput, aMax), aMin);
    }

    public static String formatNumbers(long aNumber) {
        return sNumberFormat.format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return sNumberFormat.format(aNumber);
    }

    static {
        sNumberFormat.setMaximumFractionDigits(2);
    }
}

