/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEDieselEngine;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEExtremeDieselEngine
extends MTEDieselEngine {
    public MTEExtremeDieselEngine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExtremeDieselEngine(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Combustion Generator, ECE").addInfo("Supply high rating fuel and 8000L of Lubricant per hour to run").addInfo("Supply 40L/s of Liquid Oxygen to boost output (optional)").addInfo("Default: Produces 10900EU/t at 100% fuel efficiency").addInfo("Boosted: Produces 32700EU/t at 150% fuel efficiency").addInfo("You need to wait for it to reach 300% to output full power").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 4, false).addController("Front center").addCasingInfoRange("Robust Tungstensteel Machine Casing", 16, 22, false).addOtherStructurePart("Titanium Gear Box Machine Casing", "Inner 2 blocks").addOtherStructurePart("Extreme Engine Intake Machine Casing", "8x, ring around controller").addStructureInfo("Extreme Engine Intake Casings must not be obstructed in front (only air blocks)").addDynamoHatch("Back center", 2).addMaintenanceHatch("One of the casings next to a Gear Box", 1).addMufflerHatch("Top middle back, above the rear Gear Box", 1).addInputHatch("HOG, next to a Gear Box", 1).addInputHatch("Lubricant, next to a Gear Box", 1).addInputHatch("Liquid Oxygen, optional, next to a Gear Box", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public RecipeMap<FuelBackend> getRecipeMap() {
        return RecipeMaps.extremeDieselFuels;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][60], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][60], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_EXTREME_DIESEL_ENGINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][60]};
    }

    @Override
    public byte getCasingMeta() {
        return 0;
    }

    @Override
    public Block getIntakeBlock() {
        return GregTechAPI.sBlockCasings8;
    }

    @Override
    public byte getIntakeMeta() {
        return 4;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 60;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExtremeDieselEngine(this.mName);
    }

    @Override
    protected int getNominalOutput() {
        return 10900;
    }

    @Override
    protected Materials getBooster() {
        return Materials.LiquidOxygen;
    }

    @Override
    protected int getEfficiencyIncrease() {
        return 20;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.proxy.mPollutionExtremeCombustionEnginePerSecond;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchDynamo tHatch : GTUtility.validMTEList(this.mDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.infodata.extreme_diesel_engine") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.engine.output") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers((long)(-this.mEUt) * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.engine.consumption") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.fuelConsumption) + EnumChatFormatting.RESET + " L/t", StatCollector.func_74838_a((String)"GT5U.engine.value") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.fuelValue) + EnumChatFormatting.RESET + " EU/L", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GTUtility.formatNumbers(this.fuelRemaining) + EnumChatFormatting.RESET + " L", StatCollector.func_74838_a((String)"GT5U.engine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.YELLOW + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }
}

