/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import makeo.gadomancy.client.effect.CheckpointingSet;
import makeo.gadomancy.client.effect.fx.FXFlow;
import makeo.gadomancy.client.effect.fx.FXVortex;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class EffectHandler {
    public static final EffectHandler instance = new EffectHandler();
    private static final CheckpointingSet<Orbital> orbitals = new CheckpointingSet();
    private static final CheckpointingSet<FXFlow> fxFlows = new CheckpointingSet();
    private static final CheckpointingSet<FXVortex> fxVortexes = new CheckpointingSet();

    public static EffectHandler getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        Tessellator tessellator = Tessellator.field_78398_a;
        FXFlow.FXFlowBase.sheduleRender(tessellator);
        Orbital.sheduleRenders(orbitals, event.partialTicks);
        FXVortex.sheduleRender(fxVortexes, tessellator, event.partialTicks);
        orbitals.update();
        fxFlows.update();
        fxVortexes.update();
    }

    public FXFlow effectFlow(World world, Vector3 origin, FXFlow.EntityFlowProperties properties) {
        FXFlow flow = new FXFlow(world);
        flow.applyProperties(properties).setPosition(origin);
        this.registerFlow(flow);
        return flow;
    }

    public void registerVortex(FXVortex vortex) {
        fxVortexes.add(vortex);
        vortex.registered = true;
    }

    public void unregisterVortex(FXVortex vortex) {
        fxVortexes.remove(vortex);
        vortex.registered = false;
    }

    public void registerFlow(FXFlow flow) {
        fxFlows.add(flow);
    }

    public void unregisterFlow(FXFlow flow) {
        fxFlows.remove(flow);
    }

    public void registerOrbital(Orbital orbital) {
        orbitals.add(orbital);
        orbital.registered = true;
    }

    public void unregisterOrbital(Orbital orbital) {
        orbitals.remove(orbital);
        orbital.registered = false;
    }

    public void tick() {
        Orbital.tickOrbitals(orbitals);
        FXFlow.tickFlows(fxFlows);
        FXVortex.tickVortexes(fxVortexes);
    }

    public void clear() {
        orbitals.clear();
        fxFlows.clear();
        fxVortexes.clear();
    }
}

