/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.ExistingConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.me.Grid;
import appeng.me.GridException;
import appeng.me.GridNode;
import appeng.me.GridPropagator;
import appeng.me.pathfinding.IPathItem;
import appeng.util.Platform;
import appeng.util.ReadOnlyCollection;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class GridConnection
implements IGridConnection,
IPathItem {
    private static final String EXISTING_CONNECTION_MESSAGE = "Connection between node [machine=%s, %s] and [machine=%s, %s] on [%s] already exists.";
    private static final MENetworkChannelsChanged EVENT = new MENetworkChannelsChanged();
    int usedChannels = 0;
    private int lastUsedChannels = 0;
    private Object visitorIterationNumber = null;
    private GridNode sideA;
    private ForgeDirection fromAtoB;
    private GridNode sideB;

    @Override
    public IGridNode getOtherSide(IGridNode gridNode) {
        if (gridNode == this.sideA) {
            return this.sideB;
        }
        if (gridNode == this.sideB) {
            return this.sideA;
        }
        throw new GridException("Invalid Side of Connection");
    }

    @Override
    public ForgeDirection getDirection(IGridNode side) {
        if (this.fromAtoB == ForgeDirection.UNKNOWN) {
            return this.fromAtoB;
        }
        if (this.sideA == side) {
            return this.fromAtoB;
        }
        return this.fromAtoB.getOpposite();
    }

    @Override
    public void destroy() {
        if (AEConfig.instance.debugPathFinding) {
            String aCoordinates = this.sideA.getGridBlock().getLocation().toString();
            String bCoordinates = this.sideB.getGridBlock().getLocation().toString();
            AELog.info("Repath is triggered by destroying connection from [%s] to [%s]", aCoordinates, bCoordinates);
            AELog.printStackTrace(Level.INFO);
        }
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        this.sideA.removeConnection(this);
        this.sideB.removeConnection(this);
        this.sideA.validateGrid();
        this.sideB.validateGrid();
    }

    @Override
    public GridNode a() {
        return this.sideA;
    }

    @Override
    public GridNode b() {
        return this.sideB;
    }

    @Override
    public boolean hasDirection() {
        return this.fromAtoB != ForgeDirection.UNKNOWN;
    }

    @Override
    public int getUsedChannels() {
        return this.lastUsedChannels;
    }

    @Override
    public void setAdHocChannels(int channels) {
        this.usedChannels = channels;
    }

    @Override
    public IPathItem getControllerRoute() {
        return this.sideA;
    }

    @Override
    public void setControllerRoute(IPathItem fast) {
        this.usedChannels = 0;
        if (this.sideB == fast) {
            GridNode tmp = this.sideA;
            this.sideA = this.sideB;
            this.sideB = tmp;
            this.fromAtoB = this.fromAtoB.getOpposite();
        }
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return new ReadOnlyCollection<IPathItem>(this.a(), this.b());
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.usedChannels += usedChannels;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    @Override
    public boolean hasFlag(GridFlags flag) {
        return false;
    }

    public int propagateChannelsUpwards() {
        this.usedChannels = this.sideB.getControllerRoute() == this ? this.sideB.usedChannels : 0;
        return this.usedChannels;
    }

    @Override
    public void finalizeChannels() {
        if (this.lastUsedChannels != this.usedChannels) {
            this.lastUsedChannels = this.usedChannels;
            if (this.sideA.getInternalGrid() != null) {
                this.sideA.getInternalGrid().postEventTo(this.sideA, EVENT);
            }
            if (this.sideB.getInternalGrid() != null) {
                this.sideB.getInternalGrid().postEventTo(this.sideB, EVENT);
            }
        }
    }

    Object getVisitorIterationNumber() {
        return this.visitorIterationNumber;
    }

    void setVisitorIterationNumber(Object visitorIterationNumber) {
        this.visitorIterationNumber = visitorIterationNumber;
    }

    public GridConnection(IGridNode aNode, IGridNode bNode, @Nullable ForgeDirection fromAtoB) throws SecurityConnectionException, ExistingConnectionException {
        Objects.requireNonNull(aNode, "aNode");
        Objects.requireNonNull(bNode, "bNode");
        Preconditions.checkArgument((aNode != bNode ? 1 : 0) != 0, (Object)"Cannot connect node to itself");
        if (Platform.securityCheck((GridNode)aNode, (GridNode)bNode)) {
            if (AEConfig.instance.isFeatureEnabled(AEFeature.LogSecurityAudits)) {
                DimensionalCoord aCoordinates = aNode.getGridBlock().getLocation();
                DimensionalCoord bCoordinates = bNode.getGridBlock().getLocation();
                AELog.info("Security audit 1 failed at [%s] belonging to player [id=%d]", aCoordinates.toString(), aNode.getPlayerID());
                AELog.info("Security audit 2 failed at [%s] belonging to player [id=%d]", bCoordinates.toString(), bNode.getPlayerID());
            }
            throw new SecurityConnectionException();
        }
        GridNode a = (GridNode)aNode;
        GridNode b = (GridNode)bNode;
        if (a.hasConnection(b) || b.hasConnection(a)) {
            String aMachineClass = a.getGridBlock().getMachine().getClass().getSimpleName();
            String bMachineClass = b.getGridBlock().getMachine().getClass().getSimpleName();
            String aCoordinates = a.getGridBlock().getLocation().toString();
            String bCoordinates = b.getGridBlock().getLocation().toString();
            throw new ExistingConnectionException(String.format(EXISTING_CONNECTION_MESSAGE, aMachineClass, aCoordinates, bMachineClass, bCoordinates, fromAtoB));
        }
        this.sideA = a;
        this.fromAtoB = fromAtoB == null ? ForgeDirection.UNKNOWN : fromAtoB;
        this.sideB = b;
        GridConnection.mergeGrids(a, b);
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        if (AEConfig.instance.debugPathFinding) {
            String aCoordinates = a.getGridBlock().getLocation().toString();
            String bCoordinates = b.getGridBlock().getLocation().toString();
            AELog.info("Repath is triggered by adding connection from [%s] to [%s]", aCoordinates, bCoordinates);
            AELog.printStackTrace(Level.INFO);
        }
        p.repath();
        this.sideA.addConnection(this);
        this.sideB.addConnection(this);
    }

    private static void mergeGrids(GridNode a, GridNode b) {
        Grid gridA = a.getMyGrid();
        Grid gridB = b.getMyGrid();
        if (gridA == null && gridB == null) {
            GridConnection.assertNodeIsStandalone(a);
            GridConnection.assertNodeIsStandalone(b);
            Grid grid = new Grid(a);
            a.setGrid(grid);
            b.setGrid(grid);
        } else if (gridA == null) {
            GridConnection.assertNodeIsStandalone(a);
            a.setGrid(gridB);
        } else if (gridB == null) {
            GridConnection.assertNodeIsStandalone(b);
            b.setGrid(gridA);
        } else if (gridA != gridB) {
            if (GridConnection.isGridABetterThanGridB(gridA, gridB)) {
                GridPropagator gp = new GridPropagator(a.getInternalGrid());
                b.beginVisit(gp);
            } else {
                GridPropagator gp = new GridPropagator(b.getInternalGrid());
                a.beginVisit(gp);
            }
        }
    }

    private static boolean isGridABetterThanGridB(Grid gridA, Grid gridB) {
        if (gridA.getPriority() != gridB.getPriority()) {
            return gridA.getPriority() > gridB.getPriority();
        }
        return gridA.size() >= gridB.size();
    }

    private static void assertNodeIsStandalone(GridNode node) {
        if (!node.hasNoConnections()) {
            throw new IllegalStateException("Grid node " + node + " has no grid, but is connected: " + node.getConnections());
        }
    }
}

