/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.ISettableState;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;

public class MaterialState
implements ISettableState<MaterialState> {
    private static final Vector4f vector4f = new Vector4f();
    private static final Vector4i vector4i = new Vector4i();
    private static final Vector3f vector3f = new Vector3f();
    private static final Vector3i vector3i = new Vector3i();
    public int face;
    public final Vector4f ambient;
    public final Vector4f diffuse;
    public final Vector4f specular;
    public final Vector4f emission;
    public float shininess;
    public final Vector3f colorIndexes;

    public MaterialState(int face) {
        this.face = face;
        this.ambient = new Vector4f(0.2f, 0.2f, 0.2f, 1.0f);
        this.diffuse = new Vector4f(0.8f, 0.8f, 0.8f, 1.0f);
        this.specular = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.emission = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.shininess = 0.0f;
        this.colorIndexes = new Vector3f(0.0f, 1.0f, 1.0f);
    }

    public void setAmbient(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4608, (FloatBuffer)newBuffer);
        }
    }

    public void setAmbient(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(MaterialState.vector4i.x), GLStateManager.i2f(MaterialState.vector4i.y), GLStateManager.i2f(MaterialState.vector4i.z), GLStateManager.i2f(MaterialState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4608, (IntBuffer)newBuffer);
        }
    }

    public void setDiffuse(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.diffuse.equals((Object)vector4f)) {
            this.diffuse.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4609, (FloatBuffer)newBuffer);
        }
    }

    public void setDiffuse(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(MaterialState.vector4i.x), GLStateManager.i2f(MaterialState.vector4i.y), GLStateManager.i2f(MaterialState.vector4i.z), GLStateManager.i2f(MaterialState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.diffuse.equals((Object)vector4f)) {
            this.diffuse.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4609, (IntBuffer)newBuffer);
        }
    }

    public void setSpecular(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.specular.equals((Object)vector4f)) {
            this.specular.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4610, (FloatBuffer)newBuffer);
        }
    }

    public void setSpecular(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(MaterialState.vector4i.x), GLStateManager.i2f(MaterialState.vector4i.y), GLStateManager.i2f(MaterialState.vector4i.z), GLStateManager.i2f(MaterialState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.specular.equals((Object)vector4f)) {
            this.specular.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)4610, (IntBuffer)newBuffer);
        }
    }

    public void setEmission(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.emission.equals((Object)vector4f)) {
            this.emission.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)5632, (FloatBuffer)newBuffer);
        }
    }

    public void setEmission(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(MaterialState.vector4i.x), GLStateManager.i2f(MaterialState.vector4i.y), GLStateManager.i2f(MaterialState.vector4i.z), GLStateManager.i2f(MaterialState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.emission.equals((Object)vector4f)) {
            this.emission.set((Vector4fc)vector4f);
            GL11.glMaterial((int)this.face, (int)5632, (IntBuffer)newBuffer);
        }
    }

    public void setShininess(float val) {
        if (GLStateManager.shouldBypassCache() || Float.compare(this.shininess, val) != 0) {
            this.shininess = val;
            GL11.glMaterialf((int)this.face, (int)5633, (float)val);
        }
    }

    public void setShininess(FloatBuffer newBuffer) {
        this.setShininess(newBuffer.get());
    }

    public void setShininess(IntBuffer newBuffer) {
        this.setShininess((float)newBuffer.get());
    }

    public void setShininess(int val) {
        this.setShininess((float)val);
    }

    public void setColorIndexes(FloatBuffer newBuffer) {
        if (GLStateManager.vendorIsNVIDIA()) {
            vector3f.set(newBuffer.get(0), newBuffer.get(2), newBuffer.get(1));
        } else {
            vector3f.set(newBuffer);
        }
        if (GLStateManager.shouldBypassCache() || !this.colorIndexes.equals((Object)vector3f)) {
            this.colorIndexes.set((Vector3fc)vector3f);
            GL11.glMaterial((int)this.face, (int)5635, (FloatBuffer)newBuffer);
        }
    }

    public void setColorIndexes(IntBuffer newBuffer) {
        vector3i.set(newBuffer.get(0), newBuffer.get(2), newBuffer.get(1));
        vector3f.set((float)MaterialState.vector3i.x, (float)MaterialState.vector3i.y, (float)MaterialState.vector3i.z);
        if (GLStateManager.shouldBypassCache() || !this.colorIndexes.equals((Object)vector3f)) {
            this.colorIndexes.set((Vector3fc)vector3f);
            GL11.glMaterial((int)this.face, (int)5635, (IntBuffer)newBuffer);
        }
    }

    @Override
    public MaterialState set(MaterialState state) {
        this.ambient.set((Vector4fc)state.ambient);
        this.diffuse.set((Vector4fc)state.diffuse);
        this.specular.set((Vector4fc)state.specular);
        this.emission.set((Vector4fc)state.emission);
        this.shininess = state.shininess;
        this.colorIndexes.set((Vector3fc)state.colorIndexes);
        return this;
    }

    @Override
    public boolean sameAs(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof MaterialState)) {
            return false;
        }
        MaterialState materialState = (MaterialState)state;
        return this.ambient.equals((Object)materialState.ambient) && this.diffuse.equals((Object)materialState.diffuse) && this.specular.equals((Object)materialState.specular) && this.emission.equals((Object)materialState.emission) && Float.compare(materialState.shininess, this.shininess) == 0 && this.colorIndexes.equals((Object)materialState.colorIndexes);
    }

    @Override
    public MaterialState copy() {
        return new MaterialState(this.face).set(this);
    }
}

